/*
 * HFP tx core interface.
 * Copyright (C) 2016 David Keller <david.keller@enyx.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
#ifndef HFP_TX_DEV_H
#define HFP_TX_DEV_H

#include <linux/kernel.h>

#include "enyx_hfp_bus.h"

struct enyx_hfp_tx_dev
{
    int
    (*enable_all_channels)(struct enyx_hfp_tx_dev * dev);

    int
    (*enable_channel)(struct enyx_hfp_tx_dev * dev,
                      uint16_t channel_id);

    void
    (*disable_all_channels)(struct enyx_hfp_tx_dev * dev);

    void
    (*disable_channel)(struct enyx_hfp_tx_dev * dev,
                       uint16_t channel_id);

    size_t
    (*get_channel_count)(struct enyx_hfp_tx_dev * dev);

    size_t
    (*get_usage)(struct enyx_hfp_tx_dev * dev, uint16_t channel_id,
                 char * buffer, size_t buffer_size);

    size_t
    (*get_mtu)(struct enyx_hfp_tx_dev * dev, uint16_t channel_id);

    size_t
    (*get_buffer_size)(struct enyx_hfp_tx_dev * dev, uint16_t channel_id);

    size_t
    (*get_ctrl_size)(struct enyx_hfp_tx_dev * dev);

    int
    (*send)(struct enyx_hfp_tx_dev * dev,
            uint16_t channel_id,
            const void * data_ptr,
            uint32_t data_size);

    int
    (*mmap_ctrl)(struct enyx_hfp_tx_dev * dev, struct vm_area_struct * vma,
                 uint16_t channel_id);

    int
    (*mmap_buffer)(struct enyx_hfp_tx_dev * dev, struct vm_area_struct * vma,
                   uint16_t channel_id);
};

struct enyx_hfp_tx_dev *
enyx_hfp_tx_dev_create(struct enyx_hfp_device * parent,
                  size_t coherency_line_size);

void
enyx_hfp_tx_dev_destroy(struct enyx_hfp_tx_dev * bus);

#endif /* HFP_TX_DEV_H */

