#pragma once

#include <iosfwd>
#include <vector>

#include <enyx/cores/namespace.hpp>

#include "Range.hpp"

ENYX_CORES_NAMESPACE_BEGIN

template<typename Type>
using Ranges = std::vector<Range<Type>>;

template<typename Type>
std::istream &
operator>>(std::istream & in, Ranges<Type> & ranges);

template<typename Type>
std::ostream &
operator<<(std::ostream & out, const Ranges<Type> & ranges);

template<typename Type>
std::vector<Type>
as_sequence(const Ranges<Type> & ranges);

ENYX_CORES_NAMESPACE_END

#include "Ranges.ipp"
