#pragma once

#include <system_error>

#include <enyx/cores/namespace.hpp>

ENYX_CORES_NAMESPACE_BEGIN

namespace error {

enum Error
{
    success = 0,
    generic_fault = 1,
    unexpected_eof = 2,
    checksum_failed = 3,
    test_timeout = 4,
    unexpected_data = 5,
};

std::error_code
make_error_code(Error e);

} // namespace error

const std::error_category &
tester_category();

ENYX_CORES_NAMESPACE_END

namespace std {

template<>
struct is_error_code_enum<enyx::error::Error>
{ static const bool value =  true; };

} // namespace std
