#include "CmdLine.hpp"

#include <sstream>
#include <stdexcept>

ENYX_CORES_NAMESPACE_BEGIN

bool
is_prefix(char const* prefix, char const* string)
{
    if (*prefix == '\0')
        return false;

    // Loop while `prefix` and `string` char are equal
    // and different from NULL
    while (*string != '\0' && *prefix == *string++)
        ++prefix;

    // Check that `prefix` is shorter or equal to `string`
    return *prefix == '\0';
}

void
ensure_end(CmdLineIterator i, CmdLineIterator e)
{
    if (i != e)
    {
        std::ostringstream error;
        error << "Spurious argument '" << *i << "'";
        throw std::runtime_error{error.str()};
    }
}

ENYX_CORES_NAMESPACE_END
