#pragma once

#include <cstdint>
#include <string>

enum class flash_command {
    READ_MEM,
    WRITE_MEM,
    READ_REG,
    WRITE_REG,
};

enum class flash_section {
    PGM,
    USR,
    PRM,
    OTP,
};

struct run_params {
    std::string accelerator = "0";
    flash_command command = flash_command::READ_REG;
    std::uint32_t size = 0;
    flash_section target = flash_section::PGM;
    std::uint32_t offset = 0;
    std::uint32_t reg_addr = 0;
    std::uint32_t reg_value = 0;
    std::string file;
};
