inline
std::ostream&
operator<<(std::ostream & out,
           ::enyx_hw_product_version const & version)
{
    std::ostream::sentry sentry{out};

    if (sentry) {
        ssize_t buffer_size = ::enyx_hw_product_version_print(&version,
                                                              nullptr,
                                                              0);
        if (buffer_size < 0) {
            throw std::system_error{
                errno,
                std::generic_category(),
                "Could not get version string size for printing"
            };
        }

        char buffer[buffer_size + 1];

        ssize_t ret = ::enyx_hw_product_version_print(&version,
                                                      buffer,
                                                      sizeof(buffer));

        if (ret < 0) {
            throw std::system_error{errno, std::generic_category(),
                                    "Could not print product version"};
        }
        out << buffer;
    }

    return out;
}
