ENYX_HW_NAMESPACE_BEGIN
namespace mocking {

inline
mmio_interface::mmio_interface()
    : mmio_(new ::enyx_hwm_mmio_interface())
{
    mmio_->context = this;
    mmio_->get_size = [] (void * context) -> ssize_t {
        mmio_interface * thiz = reinterpret_cast<mmio_interface *>(context);
        if (! thiz->get_size) {
            errno = ENOSYS;
            return -1;
        }
        return thiz->get_size();
    };

    mmio_->get_uid = [] (void * context, char * buffer, size_t capacity) -> int {
        mmio_interface * thiz = reinterpret_cast<mmio_interface *>(context);
        if (! thiz->get_uid) {
            errno = ENOSYS;
            return -1;
        }
        std::strncpy(buffer, thiz->get_uid().c_str(), capacity);
        return 0;
    };

    mmio_->get_name = [] (void * context, char * buffer, size_t capacity) -> int {
        mmio_interface * thiz = reinterpret_cast<mmio_interface *>(context);
        if (! thiz->get_name) {
            errno = ENOSYS;
            return -1;
        }
        std::strncpy(buffer, thiz->get_name().c_str(), capacity);
        return 0;
    };

    mmio_->write_8 = [] (void * context, uint64_t addr, uint8_t value) -> int {
        mmio_interface * thiz = reinterpret_cast<mmio_interface *>(context);
        if (! thiz->write_8) {
            errno = ENOSYS;
            return -1;
        }
        return thiz->write_8(addr, value);
    };

    mmio_->write_16 = [] (void * context, uint64_t addr, uint16_t value) -> int {
        mmio_interface * thiz = reinterpret_cast<mmio_interface *>(context);
        if (! thiz->write_16) {
            errno = ENOSYS;
            return -1;
        }
        return thiz->write_16(addr, value);
    };

    mmio_->write_32 = [] (void * context, uint64_t addr, uint32_t value) -> int {
        mmio_interface * thiz = reinterpret_cast<mmio_interface *>(context);
        if (! thiz->write_32) {
            errno = ENOSYS;
            return -1;
        }
        return thiz->write_32(addr, value);
    };

    mmio_->write_64 = [] (void * context, uint64_t addr, uint64_t value) -> int {
        mmio_interface * thiz = reinterpret_cast<mmio_interface *>(context);
        if (! thiz->write_64) {
            errno = ENOSYS;
            return -1;
        }
        return thiz->write_64(addr, value);
    };

    mmio_->read_8 = [] (void * context, uint64_t addr, uint8_t * value) -> int {
        mmio_interface * thiz = reinterpret_cast<mmio_interface *>(context);
        if (! thiz->read_8) {
            errno = ENOSYS;
            return -1;
        }
        return thiz->read_8(addr, value);
    };

    mmio_->read_16 = [] (void * context, uint64_t addr, uint16_t * value) -> int {
        mmio_interface * thiz = reinterpret_cast<mmio_interface *>(context);
        if (! thiz->read_16) {
            errno = ENOSYS;
            return -1;
        }
        return thiz->read_16(addr, value);
    };

    mmio_->read_32 = [] (void * context, uint64_t addr, uint32_t * value) -> int {
        mmio_interface * thiz = reinterpret_cast<mmio_interface *>(context);
        if (! thiz->read_32) {
            errno = ENOSYS;
            return -1;
        }
        return thiz->read_32(addr, value);
    };

    mmio_->read_64 = [] (void * context, uint64_t addr, uint64_t * value) -> int {
        mmio_interface * thiz = reinterpret_cast<mmio_interface *>(context);
        if (! thiz->read_64) {
            errno = ENOSYS;
            return -1;
        }
        return thiz->read_64(addr, value);
    };
}

inline ::enyx_hwm_mmio_interface *
mmio_interface::handle() noexcept
{
    return mmio_.get();
}

inline ::enyx_hwm_mmio_interface const *
mmio_interface::handle() const noexcept
{
    return mmio_.get();
}

inline
mmio::mmio(core & root,
           std::uint8_t addr_width)
    : mmio_interface()
    , handle_(::enyx_hwm_mmio_create(handle(), root.handle(),
                                     addr_width))
{
    if (handle_ == nullptr)
        throw std::runtime_error{"Failed to create_mmio"};
}

inline
mmio::~mmio() = default;

inline ::enyx_hwm_mmio *
mmio::mmio_handle() noexcept
{
    return handle_.get();
}

inline ::enyx_hwm_mmio const *
mmio::mmio_handle() const noexcept
{
    return handle_.get();
}

} /* namespace mocking */
ENYX_HW_NAMESPACE_END
