ENYX_CORES_NAMESPACE_BEGIN
namespace tcp {

template<typename OnStateChange, typename OnCreditChange, typename OnEmiError>
inline
context::context(OnStateChange && on_state_change,
                 OnCreditChange && on_credit_change,
                 OnEmiError && on_emi_error)
    : wrapper_(new wrapper<OnStateChange, OnCreditChange, OnEmiError>
                    {std::forward<OnStateChange>(on_state_change),
                     std::forward<OnCreditChange>(on_credit_change),
                     std::forward<OnEmiError>(on_emi_error)})
    , io_context_(::enyx_tcp_context_create(
                    abstract_wrapper::on_state_change,
                    abstract_wrapper::on_credit_change,
                    abstract_wrapper::on_emi_error,
                    wrapper_.get()))
{
    if (! io_context_)
        throw std::system_error{errno, std::generic_category(),
                                "Failed to create TCP IO context"};
}

inline void
context::operator()(std::uint8_t const * data,
                    std::uint32_t size,
                    void const * metadata)
{
    ::enyx_tcp_context_on_emi_data(data, size, metadata, handle());
}

inline ::enyx_data_stream_source
context::as_next_source() const noexcept
{
    return { handle(), ::enyx_tcp_context_on_emi_data };
}

inline ::enyx_tcp_context *
context::handle() const noexcept
{
    return io_context_.get();
}

} /* namespace tcp */
ENYX_CORES_NAMESPACE_END
