ENYX_CORES_NAMESPACE_BEGIN
namespace igmp {

inline
igmp::igmp(enyx::hw::core const& igmp_core)
    : igmp_core_(igmp_core),
      handle_(::enyx_igmp_create(igmp_core_.handle()))

{
    if (! handle_)
        throw std::system_error{errno, std::generic_category(),
                                "Failed to create IGMP"};
}

inline enyx::hw::core
igmp::get_core() const noexcept
{
    return igmp_core_;
}

inline bool
igmp::enabled() const noexcept
{
    return ::enyx_igmp_enabled(handle());
}

inline result<void>
igmp::enable() noexcept
{
    if (::enyx_igmp_enable(handle()) != 0)
        return std::error_code{errno, std::generic_category()};
    return {};
}

inline result<void>
igmp::disable() noexcept
{
    if (::enyx_igmp_disable(handle()) != 0)
        return std::error_code{errno, std::generic_category()};
    return {};
}

inline ::enyx_igmp const *
igmp::handle() const noexcept
{
    return handle_.get();
}

inline ::enyx_igmp *
igmp::handle() noexcept
{
    return handle_.get();
}

} /* namespace igmp */
ENYX_CORES_NAMESPACE_END
