ENYX_CORES_NAMESPACE_BEGIN

namespace hw_top {

inline
hw_top::hw_top(enyx::hw::core const & subtree)
    : subtree_root_(subtree)
    , hw_top_c_(::enyx_hw_top_create(subtree_root_.handle()))
{
    if (! hw_top_c_)
        throw std::system_error{errno, std::generic_category(),
            "Failed to create hw_top subsystem"};
}

inline result<time_t>
hw_top::get_build_date() const noexcept
{
    time_t build_date;
    if (enyx_hw_top_get_build_date(handle(), &build_date) < 0)
        return std::error_code{errno, std::generic_category()};

    return build_date;
}

inline result<std::uint32_t>
hw_top::get_seed() const noexcept
{
    uint32_t value;
    if (enyx_hw_top_get_seed(handle(), &value) < 0)
        return std::error_code{errno, std::generic_category()};

    return value;
}

inline result<std::uint32_t>
hw_top::get_fpga_uptime() const noexcept
{
    uint32_t value;
    if (enyx_hw_top_get_fpga_uptime(handle(), &value) < 0)
        return std::error_code{errno, std::generic_category()};

    return value;
}

inline result<serial_id>
hw_top::get_fpga_serial_id() const noexcept
{
    ::enyx_hw_top_fpga_serial_id serial;
    if (enyx_hw_top_get_fpga_serial_id(handle(), &serial) < 0)
        return std::error_code{errno, std::generic_category()};

    return serial;
}

inline result<double>
hw_top::get_temperature() const noexcept
{
    double value;
    if (enyx_hw_top_get_temperature(handle(), &value) < 0)
        return std::error_code{errno, std::generic_category()};

    return value;
}

inline result<std::uint32_t>
hw_top::get_memories_init_status() const noexcept
{
    uint32_t value;
    if (enyx_hw_top_get_memories_init_status(handle(), &value) < 0)
        return std::error_code{errno, std::generic_category()};

    return value;
}

inline result<std::uint64_t>
hw_top::get_unique_identifier() const noexcept
{
    uint64_t value;
    if (enyx_hw_top_get_unique_identifier(handle(), &value) < 0)
        return std::error_code{errno, std::generic_category()};

    return value;
}

inline result<std::uint8_t>
hw_top::get_stream_count() const noexcept
{
    uint8_t value;
    if (enyx_hw_top_get_stream_count(handle(), &value) < 0)
        return std::error_code{errno, std::generic_category()};

    return value;
}

inline result<std::uint8_t>
hw_top::get_memory_count() const noexcept
{
    uint8_t value;
    if (enyx_hw_top_get_memory_count(handle(), &value) < 0)
        return std::error_code{errno, std::generic_category()};

    return value;
}

inline result<std::uint8_t>
hw_top::get_clock_count() const noexcept
{
    uint8_t value;
    if (enyx_hw_top_get_clock_count(handle(), &value) < 0)
        return std::error_code{errno, std::generic_category()};

    return value;
}

inline result<std::uint32_t>
hw_top::get_clock_frequency() const noexcept
{
    uint32_t value;
    if (enyx_hw_top_get_clock_frequency(handle(), &value) < 0)
        return std::error_code{errno, std::generic_category()};

    return value;
}

inline std::vector<mac_address>
hw_top::get_mac_addresses() const noexcept
{
    auto mac_count = enyx_hw_top_get_mac_addresses(handle(), nullptr, 0);
    if (mac_count < 0)
        return {};

    std::vector<enyx_mac_address> addresses_c{uint64_t(mac_count)};
    auto res = enyx_hw_top_get_mac_addresses(handle(), addresses_c.data(),
                                             addresses_c.size());
    if (res < 0)
        return {};

    std::vector<mac_address> addresses;
    for (auto addr: addresses_c)
        addresses.push_back(addr);

    return addresses;
}

inline result<std::uint32_t>
hw_top::get_board_serial_id() const noexcept
{
    uint32_t value;
    if (enyx_hw_top_get_board_serial_id(handle(), &value) < 0)
        return std::error_code{errno, std::generic_category()};

    return value;
}

inline result<void>
hw_top::reset_global() noexcept
{
    if (enyx_hw_top_reset_global(handle()) < 0)
        return std::error_code{errno, std::generic_category()};
    return {};
}

inline result<void>
hw_top::reset_module() noexcept
{
    if (enyx_hw_top_reset_module(handle()) < 0)
        return std::error_code{errno, std::generic_category()};
    return {};
}

inline result<void>
hw_top::reset_phy(uint64_t mask) noexcept
{
    if (enyx_hw_top_reset_phy(handle(), mask) < 0)
        return std::error_code{errno, std::generic_category()};
    return {};
}

inline result<void>
hw_top::update_params() noexcept
{
    if (enyx_hw_top_update_params(handle()) < 0)
        return std::error_code{errno, std::generic_category()};
    return {};
}

inline result<std::string>
hw_top::get_top_name() const noexcept
{
    char buffer[128];

    if (enyx_hw_top_get_top_name(handle(), buffer, sizeof(buffer)) < 0)
        return std::error_code{errno, std::generic_category()};

    return buffer;
}

inline result<std::string>
hw_top::get_product_id() const noexcept
{
    char buffer[128];

    if (enyx_hw_top_get_product_id(handle(), buffer, sizeof(buffer)) < 0)
        return std::error_code{errno, std::generic_category()};

    return buffer;
}

inline result<std::string>
hw_top::get_build_host() const noexcept
{
    char buffer[128];

    if (enyx_hw_top_get_build_host(handle(), buffer, sizeof(buffer)) < 0)
        return std::error_code{errno, std::generic_category()};

    return buffer;
}

inline result<std::string>
hw_top::get_build_tool() const noexcept
{
    char buffer[128];

    if (enyx_hw_top_get_build_tool(handle(), buffer, sizeof(buffer)) < 0)
        return std::error_code{errno, std::generic_category()};

    return buffer;
}

inline result<std::string>
hw_top::get_device_id() const noexcept
{
    char buffer[128];

    if (enyx_hw_top_get_device_id(handle(), buffer, sizeof(buffer)) < 0)
        return std::error_code{errno, std::generic_category()};

    return buffer;
}

inline result<std::string>
hw_top::get_board_name() const noexcept
{
    char buffer[128];

    if (enyx_hw_top_get_board_name(handle(), buffer, sizeof(buffer)) < 0)
        return std::error_code{errno, std::generic_category()};

    return buffer;
}

inline enyx_hw_top *
hw_top::handle() noexcept
{
    return hw_top_c_.get();
}

inline enyx_hw_top const *
hw_top::handle() const noexcept
{
    return hw_top_c_.get();
}

} /* namespace hw_top*/

ENYX_CORES_NAMESPACE_END
