#!/bin/bash

# check num of argument
if [ "$#" -ne 1 ]
then
	echo "Usage: $0 [install|uninstall]"
	exit 1
fi

if [ "$1" == "install" ]
then
	# find where this shell script is
	SHELLDIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

	# check whether dkms is installed
	echo "Check dkms command..."
	if ! command -v dkms >/dev/null 2>&1
	then
		printf "Please install dkms first(internet is needed)\n"
		printf "\tClearLinux: swupd bundle-add dkms\n"
		printf "\tCentOS/Redhat/Fedora/openSuse:\n\t\tyum install release-epel\n\t\tyum install dkms\n"
		printf "\tUbuntu: apt install dkms\n"
		exit 1
	fi

	# check whether rsync is installed
	echo "Check rsync command..."
	if ! command -v rsync >/dev/null 2>&1
	then
		printf "Please install rsync first(internet is needed)\n"
		printf "\tClearLinux: swupd bundle-add rsync\n"
		printf "\tCentOS/Redhat/Fedora/openSuse:\n\t\tyum install rsync\n"
		printf "\tUbuntu: apt install rsync\n"
		exit 1
	fi

	# some Linux won't create this folder, while dkms needs it.
	mkdir /var/lib/dkms 2>/dev/null

	# copy kernel modules necessary to /usr
	echo "Copy kernel module files..."
	rsync -av $SHELLDIR/usr/src /usr/

	# dkms install kernel
	$SHELLDIR/usr/bin/enyx-hfp-modules-install

	if [ $? -ne 0 ]
	then
		echo "Failed to install kernel modules, Please check the above error msg."
		exit 1
	fi

	modprobe -c | grep -i hfp >/dev/null 2>&1
	if [ $? -ne 0 ]
	then
		echo "Failed to install kernel modules, Please check the above error msg."
		exit 1
	else
		echo "Kernel module was successfully installed on the current kernel $(uname -r)"
	fi


	# copy other necessary files to /usr
	echo "Copy other files..."
	#rm -rf $SHELLDIR/usr/src/
	rsync -av $SHELLDIR/usr /

	# copy other conf files to /etc/
	echo "Copy config files..."
	rsync -av $SHELLDIR/etc /
fi

# repair links
ldconfig

# remove installed files
if [ "$1" == "uninstall" ]
then
	version_re='s!nano-xilinx-drv(, |/)([^,]+),.+$!\2!p'
	all_versions=$(dkms status nano-xilinx-drv 2>/dev/null | sed -nr "$version_re" | uniq)
	echo "DEBUG: Found versions: '$all_versions'"
	for current_version in $all_versions; do
    		dkms remove "nano-xilinx-drv/$current_version" --all || :
	done
	dkms status
	rm -rf /usr/bin/enyx*
	rm -rf /usr/include/enyx
	rm -rf /usr/lib/udev/enyx*
	rm -rf /usr/lib/udev/rules.d/*enyx*
	rm -rf /usr/lib64/*enyx*
	rm -rf /usr/share/enyx*
	rm -rf /usr/src/nano-xilinx-drv*
fi
