#include <stdio.h>
#include <stdint.h>
#include <signal.h>
#include <stdlib.h>
#include <time.h>
#include "commonheader.h"


#ifdef __cplusplus
/* so使用gcc编译,用户使用g++时会进入此逻辑中*/
extern "C" 
{
    /* 设置行情更新时的回调函数名称, 在libshfe_recv.so中定义 */
    void set_update_md_callback(void (*p)(struct instrument *));
    /* 阻塞式接收来自FPGA的行情数据,直至keep_running指向地址内容为0时停止*/
    int nano_recv(char *config, int *keep_running);
}
#else
extern void set_update_md_callback(void (*p)(struct instrument *));
extern int nano_recv(char *config, int *keep_running);
#endif

/* 运行标记,为0时停止运行 */
int keep_running = 1;
FILE* dumpHandler;

/* 示例回调函数 */
void notify(struct instrument *inst)
{
    /* 行情输出至csv文件，也可以在此实现其它处理 */
    fprintf(dumpHandler, "%u,%s,%u,%d,%d,%.2f,%d,%.2f,%.2f,%d,%.2f,%d,%.2f,%d,%.2f,%d,%.2f,%d,%.2f,%d,%.2f,%d,%.2f,%d,%.2f,%d,%.2f,%d,%.2f,%d,%.2f,%d,%.2f,%.2f,%.2f\n",
        inst->type, inst->inst_id, inst->update_time, inst->update_milli_sec, inst->change_no,
        inst->last_px, inst->volume, inst->turnover, inst->open_interest,
        inst->bid_vol[0], inst->bid_px[0], inst->bid_vol[1], inst->bid_px[1], inst->bid_vol[2],
        inst->bid_px[2], inst->bid_vol[3], inst->bid_px[3], inst->bid_vol[4], inst->bid_px[4],
        inst->ask_vol[0], inst->ask_px[0], inst->ask_vol[1], inst->ask_px[1], inst->ask_vol[2],
        inst->ask_px[2], inst->ask_vol[3], inst->ask_px[3], inst->ask_vol[4], inst->ask_px[4],
        inst->bid_totvol, inst->bid_totamount, inst->ask_totvol, inst->ask_totamount,
        inst->highest_price, inst->lowest_price);
    fflush(dumpHandler);
}

/* 当接收到Ctrl + C时停止运行程序*/
void sig_handler(int sig)
{
    keep_running = 0;
    fflush(stdout);
    printf("received Ctrl + C signal.\n");
    fclose(dumpHandler);
}

int main(int argc, char* argv[])
{
    if (argc != 2)
    {
        fprintf(stderr, "Usage: %s config.ini\n", argv[0]);
        return -1;
    }

    time_t rawtime;
    time(&rawtime);
    struct tm *timeinfo = localtime(&rawtime);
    char log_name[256] = {};
    sprintf(log_name, "exanic_md_%04d%02d%02d_%02d%02d%02d.csv", timeinfo->tm_year + 1900, timeinfo->tm_mon + 1, timeinfo->tm_mday, timeinfo->tm_hour, timeinfo->tm_min, timeinfo->tm_sec);

    /* 打开一个csv文件 */
    dumpHandler = fopen(log_name, "w");
    if (!dumpHandler)
    {
        printf("fopen: %s failed\n", log_name);
        return -1;
    }

    /* 写csv文件标题 */
    fprintf(dumpHandler, "type,inst_id,update_time,update_milli_sec,change_no,last_px,volume,turnover,open_interest,\
bid1_volume,bid1_price,bid2_volume,bid2_price,bid3_volume,bid3_price,bid4_volume,bid4_price,bid5_volume,bid5_price,\
ask1_volume,ask1_price,ask2_volume,ask2_price,ask3_volume,ask3_price,ask4_volume,ask4_price,ask5_volume,ask5_price,\
bid_volume,bid_amount,ask_volume,ask_amount,highest_price,lowest_price\n");

    signal(SIGINT, sig_handler);
    /* 将实现的notify回调函数传递给API*/
    set_update_md_callback(notify);
    /* 阻塞接收数据, 直至keep_running=0 */
    nano_recv(argv[1], &keep_running);
    return 0;
}
