#pragma once

#include <cstdint>

#pragma pack(1)

struct NanoCffexMdType 
{
    int32_t         inst_no;                  //合约编码
    char            trading_day[9];           //交易日
    char            instrument_id[31];        //合约代码
    
    int64_t         UpdateTime;              //更新时间秒
    int32_t         update_msec;             //更新时间毫秒
    int32_t         volume;                  //最新成交量
    int64_t         last_price;              //最新成交价，放大1000倍
    double          turn_over;               //成交总额
    int64_t         open_interest;           //未平仓合约数

    int32_t         bid1_volume;             //买一量
    int32_t         ask1_volume;             //卖一量
    int32_t         bid2_volume;             //买二量
    int32_t         ask2_volume;             //卖二量
    int32_t         bid3_volume;             //买三量
    int32_t         ask3_volume;             //卖三量
    int32_t         bid4_volume;             //买四量
    int32_t         ask4_volume;             //卖四量
    int32_t         bid5_volume;             //买五量
    int32_t         ask5_volume;             //卖五量

    int64_t         bid1_price;              //买一价，放大1000倍
    int64_t         ask1_price;              //卖一价，放大1000倍
    int64_t         bid2_price;              //买二价，放大1000倍
    int64_t         ask2_price;              //卖二价，放大1000倍
    int64_t         bid3_price;              //买三价，放大1000倍
    int64_t         ask3_price;              //卖三价，放大1000倍
    int64_t         bid4_price;              //买四价，放大1000倍
    int64_t         ask4_price;              //卖四价，放大1000倍
    int64_t         bid5_price;              //买五价，放大1000倍
    int64_t         ask5_price;              //卖五价，放大1000倍

    int64_t         high_price;              //最高价，放大1000倍
    int64_t         low_price;               //最低价，放大1000倍
    int64_t         open_price;              //开盘价，放大1000倍
    int64_t         close_price;             //收盘价，放大1000倍
    int64_t         upper_limit_price;       //价格上限，放大1000倍
    int64_t         lower_limit_price;       //价格下限，放大1000倍
    int64_t         settlement_price;        //结算价，放大1000倍
    int64_t         curr_delta;              //当前的期权希腊值 Delta
    int64_t         trust_flag;              //该输出DMA数据是否可信标识
};

//fieldid = 0x1
// struct depth_market_data_field
// {
//     char trading_day[8];
//     char settlement_group_id[8];
//     int32_t settlement_id;
//     double pre_settlement_price;
//     double pre_close_price;
//     double pre_open_interest;
//     double pre_delta;
//     double open_price;
//     double high_price;
//     double low_price;
//     double close_price;
//     double upper_limit_price;
//     double lower_limit_price;
//     double settlement_price;
//     double curr_delta;
//     double last_price;
//     int32_t volume;
//     double turn_over;
//     double open_interest;
//     double bid1_price;
//     int32_t bid1_volume;
//     double ask1_price;
//     int32_t ask1_volume;

//     double bid2_price;
//     int32_t bid2_volume;
//     double bid3_price;
//     int32_t bid3_volume;

//     double ask2_price;
//     int32_t ask2_volume;
//     double ask3_price;
//     int32_t ask3_volume;
//     double bid4_price;
//     int32_t bid4_volume;
//     double bid5_price;
//     int32_t bid5_volume;
//     double ask4_price;
//     int32_t ask4_volume;
//     double ask5_price;
//     int32_t ask5_volume;

//     char update_time[8];
//     int32_t update_msec;
//     char instrument_id[30];
//     int32_t inst_id;
//     double banding_upper_price;
//     double banding_lower_price;
// };


#pragma pack()