#include "NanoCffexMdApi.h"
#include <cstdio>
#include <cstdlib>
#include <time.h>
#include <thread>
#include <fstream>
#include <arpa/inet.h>
#include <iomanip> 
#include <cmath>
#include <cstring>

class CNanoCffexMdSpiImpl : public CNanoCffexMdSpi
{
public:
    CNanoCffexMdSpiImpl(int32_t instanceIndex);
    ~CNanoCffexMdSpiImpl();
public:
    virtual void OnNanoCffexMd(const NanoCffexMdType& refSNanoCffexMd);
    //virtual void OnNanoCffexMd_test(const depth_market_data_field& refSNanoCffexMd);
private:
    int32_t _CreateShowFile();
    //int32_t _CreateShowFile_test();
private:
    std::ofstream           m_fileStream;       //行情落地文件流对象
    int32_t                 m_instanceIndex = 0;
};


void NanoCffexFunc(int32_t instanceIndex)
{
    printf("NanoCffexFunc:  %d......start\n", instanceIndex);
    CNanoCffexMdSpiImpl mdSpi(instanceIndex);
    CNanoCffexMdApi& refNanoCffexMdApi = CNanoCffexMdApi::CreateNanoCffexMdApi();

    char szBuf[32] = {};
    sprintf(szBuf, "config_%d.ini", instanceIndex);
    //阻塞示例
    #if 0
    {
        printf("NanoCffexFunc: %d 阻塞模式\n", instanceIndex);
        refNanoCffexMdApi.NanoRecvStart(mdSpi, szBuf);
    }
    #endif

    //非阻塞示例
    #if 1
    {
        printf("NanoCffexFunc: %d 非阻塞模式\n", instanceIndex);
        if (0 != refNanoCffexMdApi.NanoStart(mdSpi, szBuf))
        {
            printf("NanoCffexFunc: %d NanoStart failed\n", instanceIndex);
            return;
        }
        
        int32_t nRet = -1;
        while (-1 != (nRet = refNanoCffexMdApi.NanoRecv()))
        {
            if (0 == nRet)
            {
                //printf("NanoCffexFunc: none dma data\n");
            }
            else if (1 == nRet)
            {
                //printf("NanoCffexFunc: have dma data\n");
            }
        }
    
    }
    #endif
    
    CNanoCffexMdApi::DestroyNanoCffexMdApi(refNanoCffexMdApi);
    printf("NanoCffexFunc: %d......end\n", instanceIndex);
}

int32_t main(int32_t argc, char** argv)
{
    if (argc < 2)
    {
        printf("Usage: %s config.ini\n", argv[0]);
        return -1;
    }

    int32_t InstanceCount = atoi(argv[1]);
    if ((InstanceCount < 1) || (InstanceCount > 16))
    {
        //Count ∈ [1~16]
        printf("Usage: %s Count ∈ [1~16]\n", argv[0]);
        return -1;
    }

    std::thread threadArray[16];
    for (int32_t index = 0; index < InstanceCount; ++index)
    {
        threadArray[index] = std::thread(NanoCffexFunc, index);
    }
    
    for (int32_t index = 0; index < InstanceCount; ++index)
    {
        threadArray[index].join();
    }

    // NanoCffexFunc(argv[1]);

    return 0;
}


CNanoCffexMdSpiImpl::CNanoCffexMdSpiImpl(int32_t instanceIndex)
    : m_instanceIndex(instanceIndex)
{
    _CreateShowFile();
    //_CreateShowFile_test();
}

CNanoCffexMdSpiImpl::~CNanoCffexMdSpiImpl()
{
    if (m_fileStream.is_open())
    {
        m_fileStream.flush();
        m_fileStream.close();
    }
}

void CNanoCffexMdSpiImpl::OnNanoCffexMd(const NanoCffexMdType& refSNanoCffexMd)
{
    m_fileStream << refSNanoCffexMd.inst_no                << ",";
    m_fileStream << refSNanoCffexMd.trading_day            << ",";
    m_fileStream << refSNanoCffexMd.instrument_id          << ",";
    m_fileStream << refSNanoCffexMd.UpdateTime             << ",";
    m_fileStream << refSNanoCffexMd.update_msec            << ",";
    m_fileStream << refSNanoCffexMd.volume                 << ",";
    m_fileStream << refSNanoCffexMd.last_price             << ",";
    //m_fileStream << refSNanoCffexMd.turn_over              << ",";
    m_fileStream << std::fixed << std::setprecision(3) <<refSNanoCffexMd.turn_over            << ",";
    m_fileStream << refSNanoCffexMd.open_interest          << ",";
    m_fileStream << refSNanoCffexMd.bid1_volume            << ",";
    m_fileStream << refSNanoCffexMd.ask1_volume            << ",";
    m_fileStream << refSNanoCffexMd.bid2_volume            << ",";
    m_fileStream << refSNanoCffexMd.ask2_volume            << ",";
    m_fileStream << refSNanoCffexMd.bid3_volume            << ",";
    m_fileStream << refSNanoCffexMd.ask3_volume            << ",";
    m_fileStream << refSNanoCffexMd.bid4_volume            << ",";
    m_fileStream << refSNanoCffexMd.ask4_volume            << ",";
    m_fileStream << refSNanoCffexMd.bid5_volume            << ",";
    m_fileStream << refSNanoCffexMd.ask5_volume            << ",";
    m_fileStream << refSNanoCffexMd.bid1_price             << ",";
    m_fileStream << refSNanoCffexMd.ask1_price             << ",";
    m_fileStream << refSNanoCffexMd.bid2_price             << ",";
    m_fileStream << refSNanoCffexMd.ask2_price             << ",";
    m_fileStream << refSNanoCffexMd.bid3_price             << ",";
    m_fileStream << refSNanoCffexMd.ask3_price             << ",";
    m_fileStream << refSNanoCffexMd.bid4_price             << ",";
    m_fileStream << refSNanoCffexMd.ask4_price             << ",";
    m_fileStream << refSNanoCffexMd.bid5_price             << ",";
    m_fileStream << refSNanoCffexMd.ask5_price             << ",";
    m_fileStream << refSNanoCffexMd.high_price             << ",";
    m_fileStream << refSNanoCffexMd.low_price              << ",";
    m_fileStream << refSNanoCffexMd.open_price             << ",";
    m_fileStream << refSNanoCffexMd.close_price            << ",";
    m_fileStream << refSNanoCffexMd.upper_limit_price      << ",";
    m_fileStream << refSNanoCffexMd.lower_limit_price      << ",";
    m_fileStream << refSNanoCffexMd.settlement_price       << ",";
    m_fileStream << refSNanoCffexMd.curr_delta             << ",";
    m_fileStream << refSNanoCffexMd.trust_flag <<std::endl;
}
// void CNanoCffexMdSpiImpl::OnNanoCffexMd_test(const depth_market_data_field& refSNanoCffexMd)
// {
//     m_fileStream << refSNanoCffexMd.trading_day                << ",";
//     m_fileStream << refSNanoCffexMd.settlement_group_id            << ",";
//     m_fileStream << refSNanoCffexMd.settlement_id          << ",";

//     m_fileStream << std::fixed << std::setprecision(3) << refSNanoCffexMd.pre_settlement_price << ",";

//     m_fileStream << std::fixed << std::setprecision(3) <<refSNanoCffexMd.pre_close_price            << ",";
//     m_fileStream << std::fixed << std::setprecision(3) <<refSNanoCffexMd.pre_open_interest                 << ",";
//     m_fileStream << std::fixed << std::setprecision(3) <<refSNanoCffexMd.pre_delta             << ",";
//     m_fileStream << std::fixed << std::setprecision(3) <<refSNanoCffexMd.open_price              << ",";
//     m_fileStream << std::fixed << std::setprecision(3) <<refSNanoCffexMd.high_price          << ",";
//     m_fileStream << std::fixed << std::setprecision(3) <<refSNanoCffexMd.low_price          << ",";
//     m_fileStream << std::fixed << std::setprecision(3) <<refSNanoCffexMd.close_price            << ",";
//     m_fileStream << std::fixed << std::setprecision(3) <<refSNanoCffexMd.upper_limit_price            << ",";
//     m_fileStream << std::fixed << std::setprecision(3) <<refSNanoCffexMd.lower_limit_price            << ",";
//     m_fileStream << std::fixed << std::setprecision(3) <<refSNanoCffexMd.settlement_price            << ",";
//     m_fileStream << std::fixed << std::setprecision(3) <<refSNanoCffexMd.curr_delta            << ",";
//     m_fileStream << std::fixed << std::setprecision(3) <<refSNanoCffexMd.last_price            << ",";

//     m_fileStream << refSNanoCffexMd.volume            << ",";
//     m_fileStream << std::fixed << std::setprecision(3) <<refSNanoCffexMd.turn_over            << ",";

//     m_fileStream << std::fixed << std::setprecision(3) <<refSNanoCffexMd.open_interest            << ",";
//     m_fileStream << std::fixed << std::setprecision(3) <<refSNanoCffexMd.bid1_price            << ",";

//     m_fileStream << refSNanoCffexMd.bid1_volume             << ",";
//     m_fileStream << std::fixed << std::setprecision(3) <<refSNanoCffexMd.ask1_price             << ",";
//     m_fileStream << refSNanoCffexMd.ask1_volume             << ",";
    
//     m_fileStream << std::fixed << std::setprecision(3) <<refSNanoCffexMd.bid2_price             << ",";
//     m_fileStream << refSNanoCffexMd.bid2_volume             << ",";
//     m_fileStream << std::fixed << std::setprecision(3) <<refSNanoCffexMd.ask2_price             << ",";
//     m_fileStream << refSNanoCffexMd.ask2_volume             << ",";

//     m_fileStream << std::fixed << std::setprecision(3) <<refSNanoCffexMd.bid3_price             << ",";
//     m_fileStream << refSNanoCffexMd.bid3_volume             << ",";
//     m_fileStream << std::fixed << std::setprecision(3) <<refSNanoCffexMd.ask3_price             << ",";
//     m_fileStream << refSNanoCffexMd.ask3_volume             << ",";

//     m_fileStream << std::fixed << std::setprecision(3) <<refSNanoCffexMd.bid4_price              << ",";
//     m_fileStream << refSNanoCffexMd.bid4_volume             << ",";
//     m_fileStream << std::fixed << std::setprecision(3) <<refSNanoCffexMd.ask4_price      << ",";
//     m_fileStream << refSNanoCffexMd.ask4_volume       << ",";

//     m_fileStream << std::fixed << std::setprecision(3) <<refSNanoCffexMd.bid5_price            << ",";
//     m_fileStream << refSNanoCffexMd.bid5_volume      << ",";
//     m_fileStream << std::fixed << std::setprecision(3) <<refSNanoCffexMd.ask5_price       << ",";
//     m_fileStream << refSNanoCffexMd.ask5_volume       << ",";

//     m_fileStream << refSNanoCffexMd.update_time       << ",";
//     m_fileStream << refSNanoCffexMd.update_msec       << ",";
//     m_fileStream << refSNanoCffexMd.instrument_id       << ",";
//     m_fileStream << std::fixed << std::setprecision(3) <<refSNanoCffexMd.banding_upper_price       << ",";
//     m_fileStream << std::fixed << std::setprecision(3) <<refSNanoCffexMd.banding_lower_price             << std::endl;
// }


int32_t CNanoCffexMdSpiImpl::_CreateShowFile()
{
    char file_name[256] = {};
    time_t time_now = {};
    time(&time_now);
    struct tm *tm_now = localtime(&time_now);

    sprintf(file_name, "nano_u50_channel%d_%04d%02d%02d_%02d%02d%02d.csv", m_instanceIndex, tm_now->tm_year + 1900, tm_now->tm_mon + 1, tm_now->tm_mday, tm_now->tm_hour, tm_now->tm_min, tm_now->tm_sec);
    m_fileStream.open(file_name);
    // m_fileStream.precision(6);
    m_fileStream.setf(std::ios::uppercase|std::ios::scientific);
    m_fileStream << "Inst_no,Trading_day,InstrumentID,UpdateTime,UpdateMillisec,Volume,LastPrice,Turnover,OpenInterest,BidVolume1,AskVolume1,BidVolume2,AskVolume2,BidVolume3,AskVolume3,BidVolume4,AskVolume4,BidVolume5,AskVolume5,BidPrice1,AskPrice1,BidPrice2,AskPrice2,BidPrice3,AskPrice3,BidPrice4,AskPrice4,BidPrice5,AskPrice5,HighestPrice,LowestPrice,OpenPrice,ClosePrice,UpperLimitPrice,LowerLimitPrice,SettlementPrice,CurrDelta,Trust_flag" << std::endl;
    return 0;
}

// int32_t CNanoCffexMdSpiImpl::_CreateShowFile_test()
// {
//     char file_name[256] = {};
//     time_t time_now = {};
//     time(&time_now);
//     struct tm *tm_now = localtime(&time_now);

//     sprintf(file_name, "nano_u50_level1_%04d%02d%02d_%02d%02d%02d_test.csv",  tm_now->tm_year + 1900, tm_now->tm_mon + 1, tm_now->tm_mday, tm_now->tm_hour, tm_now->tm_min, tm_now->tm_sec);
//     m_fileStream.open(file_name);
//     m_fileStream.precision(6);
//     m_fileStream.setf(std::ios::uppercase|std::ios::scientific);
//     m_fileStream << "trading_day,settlement_group_id,settlement_id,pre_settlement_price,pre_close_price,pre_open_interest,pre_delta,open_price,high_price,low_price,close_price,upper_limit_price,lower_limit_price,settlement_price,curr_delta,last_price,volume,turn_over,open_interest,\
// bid1_price,bid1_volume,ask1_price,ask1_volume,\
// bid2_price,bid2_volume,ask2_price,ask2_volume,\
// bid3_price,bid3_volume,ask3_price,ask3_volume,\
// bid4_price,bid4_volume,ask4_price,ask4_volume,\
// bid5_price,bid5_volume,ask5_price,ask5_volume,\
// update_time,update_msec,instrument_id,\
// banding_upper_price,banding_lower_price" << std::endl;
//     return 0;
// }