#include "NanoNetGfexMdApi.h"
#include <cstdio>
#include <cstdlib>
#include <time.h>
#include <fstream>
#include <iostream>

class CNanoNetGfexMdSpiImpl : public CNanoNetGfexMdSpi
{
public:
    CNanoNetGfexMdSpiImpl();
    ~CNanoNetGfexMdSpiImpl();
public:
    //一档行情回调接口
    virtual void OnNanoGfexL1Md(const NanoGfexL1MdType& refNanoGfexL1Md);


    //五档行情回调接口
    virtual void OnNanoGfexL2Md(const NanoGfexL2MdType& refNanoGfexL2Md);

private:
    int32_t _CreateShowFile();

private:
    std::ofstream           m_fileLevel1Stream;       //一档落地文件流对象
    std::ofstream           m_fileLevel2Stream;       //五档落地文件流对象
};

void NanoGfexFunc(const char* lpConfig)
{
    printf("NanoGfexFunc: ......start\n");

    if (nullptr == lpConfig)
    {
        return;
    }

    CNanoNetGfexMdSpiImpl mdSpi = {};
    CNanoNetGfexMdApi& refNanoGfexMdApi = CNanoNetGfexMdApi::CreateNanoGfexMdApi();

    //阻塞示例
    #if 1
    {
        printf("NanoGfexFunc: 阻塞模式\n");
        refNanoGfexMdApi.NanoRecvStart(mdSpi, lpConfig);
    }
    #endif

    //非阻塞示例
    #if 0
    {
        printf("NanoGfexFunc: 非阻塞模式\n");
        if (0 != refNanoGfexMdApi.NanoStart(mdSpi, lpConfig))
        {
            printf("NanoGfexFunc: NanoStart failed\n");
            return;
        }
        
        int32_t nRet = -1;
        while (-1 != (nRet = refNanoGfexMdApi.NanoRecv()))
        {
            if (0 == nRet)
            {
                //printf("NanoGfexFunc: none data\n");
            }
            else if (1 == nRet)
            {
                //printf("NanoGfexFunc: have data\n");
            }
        }
    }
    #endif

	CNanoNetGfexMdApi::DestroyNanoGfexMdApi(refNanoGfexMdApi);
    printf("NanoGfexFunc: ......end\n");
}

int32_t main(int32_t argc, char** argv)
{
    if (argc < 2)
    {
        printf("Usage: %s config.ini\n", argv[0]);
        return -1;
    }

    NanoGfexFunc(argv[1]);

    return 0;
}

CNanoNetGfexMdSpiImpl::CNanoNetGfexMdSpiImpl()
{
    _CreateShowFile();
}

CNanoNetGfexMdSpiImpl::~CNanoNetGfexMdSpiImpl()
{
    if (m_fileLevel1Stream.is_open())
    {
        m_fileLevel1Stream.flush();
        m_fileLevel1Stream.close();
    }

    if (m_fileLevel2Stream.is_open())
    {
        m_fileLevel2Stream.flush();
        m_fileLevel2Stream.close();
    }
}

int32_t CNanoNetGfexMdSpiImpl::_CreateShowFile()
{
    char file_name[256] = {};
    time_t time_now = {};
    time(&time_now);
    struct tm *tm_now = localtime(&time_now);

    //一档落地文件
    {
        sprintf(file_name, "nano_udp_level1_%04d%02d%02d_%02d%02d%02d.csv", tm_now->tm_year + 1900, tm_now->tm_mon + 1, tm_now->tm_mday, tm_now->tm_hour, tm_now->tm_min, tm_now->tm_sec);
        m_fileLevel1Stream.open(file_name);
        m_fileLevel1Stream.precision(6);
        m_fileLevel1Stream.setf(std::ios::uppercase|std::ios::scientific);
    }

    //五档落地文件
    {
        sprintf(file_name, "nano_udp_level2_%04d%02d%02d_%02d%02d%02d.csv", tm_now->tm_year + 1900, tm_now->tm_mon + 1, tm_now->tm_mday, tm_now->tm_hour, tm_now->tm_min, tm_now->tm_sec);
        m_fileLevel2Stream.open(file_name);
        m_fileLevel2Stream.precision(6);
        m_fileLevel2Stream.setf(std::ios::uppercase|std::ios::scientific);
    }

    return 0;
}

void CNanoNetGfexMdSpiImpl::OnNanoGfexL1Md(const NanoGfexL1MdType& refNanoGfexL1Md)
{
    m_fileLevel1Stream << "OnNanoGfexL1Md" << ",";
    m_fileLevel1Stream << "contract_no=" << 		refNanoGfexL1Md.contract_no << ",";
    m_fileLevel1Stream << "contract_name=" << 	    refNanoGfexL1Md.contract_name << ",";
    m_fileLevel1Stream << "send_time=" << 	        refNanoGfexL1Md.send_time << ",";
    m_fileLevel1Stream << "last_price=" <<          refNanoGfexL1Md.last_price << ",";
    m_fileLevel1Stream << "last_match_qty=" << 		refNanoGfexL1Md.last_match_qty << ",";
    m_fileLevel1Stream << "total_match_qty=" << 	refNanoGfexL1Md.total_match_qty << ",";
    m_fileLevel1Stream << "turn_over=" <<           refNanoGfexL1Md.turn_over << ",";
    m_fileLevel1Stream << "open_interest=" << 		refNanoGfexL1Md.open_interest << ",";
    m_fileLevel1Stream << "open_interest_change=" <<refNanoGfexL1Md.open_interest_change << ",";
    m_fileLevel1Stream << "bid_price=" <<           refNanoGfexL1Md.bid_price << ",";
    m_fileLevel1Stream << "bid_qty=" << 			refNanoGfexL1Md.bid_qty << ",";
    m_fileLevel1Stream << "ask_price=" <<           refNanoGfexL1Md.ask_price << ",";
    m_fileLevel1Stream << "ask_qty=" << 			refNanoGfexL1Md.ask_qty << ",";
    m_fileLevel1Stream << "avg_price=" <<           refNanoGfexL1Md.avg_price << std::endl;
}


void CNanoNetGfexMdSpiImpl::OnNanoGfexL2Md(const NanoGfexL2MdType& refNanoGfexL2Md)
{
    m_fileLevel2Stream << "OnNanoGfexL2Md" << ",";
    m_fileLevel2Stream << "contract_name=" <<        refNanoGfexL2Md.contract_name        << ",";
    m_fileLevel2Stream << "last_price=" <<           refNanoGfexL2Md.last_price           << ",";
    m_fileLevel2Stream << "last_match_qty=" <<       refNanoGfexL2Md.last_match_qty       << ",";
    m_fileLevel2Stream << "match_total_qty=" <<      refNanoGfexL2Md.match_total_qty      << ",";
    m_fileLevel2Stream << "turn_over=" <<            refNanoGfexL2Md.turn_over            << ",";
    m_fileLevel2Stream << "open_interest=" <<        refNanoGfexL2Md.open_interest        << ",";
    m_fileLevel2Stream << "open_interest_change=" << refNanoGfexL2Md.open_interest_change << ",";
    m_fileLevel2Stream << "gen_time=" <<             refNanoGfexL2Md.gen_time             << ",";
    m_fileLevel2Stream << "bid1_px=" <<              refNanoGfexL2Md.bid1_px              << ",";
    m_fileLevel2Stream << "bid1_vol=" <<             refNanoGfexL2Md.bid1_vol             << ",";
    m_fileLevel2Stream << "bid2_px=" <<              refNanoGfexL2Md.bid2_px              << ",";
    m_fileLevel2Stream << "bid2_vol=" <<             refNanoGfexL2Md.bid2_vol             << ",";
    m_fileLevel2Stream << "bid3_px=" <<              refNanoGfexL2Md.bid3_px              << ",";
    m_fileLevel2Stream << "bid3_vol=" <<             refNanoGfexL2Md.bid3_vol             << ",";
    m_fileLevel2Stream << "bid4_px=" <<              refNanoGfexL2Md.bid4_px              << ",";
    m_fileLevel2Stream << "bid4_vol=" <<             refNanoGfexL2Md.bid4_vol             << ",";
    m_fileLevel2Stream << "bid5_px=" <<              refNanoGfexL2Md.bid5_px              << ",";
    m_fileLevel2Stream << "bid5_vol=" <<             refNanoGfexL2Md.bid5_vol             << ",";
    m_fileLevel2Stream << "ask1_px=" <<              refNanoGfexL2Md.ask1_px              << ",";
    m_fileLevel2Stream << "ask1_vol=" <<             refNanoGfexL2Md.ask1_vol             << ",";
    m_fileLevel2Stream << "ask2_px=" <<              refNanoGfexL2Md.ask2_px              << ",";
    m_fileLevel2Stream << "ask2_vol=" <<             refNanoGfexL2Md.ask2_vol             << ",";
    m_fileLevel2Stream << "ask3_px=" <<              refNanoGfexL2Md.ask3_px              << ",";
    m_fileLevel2Stream << "ask3_vol=" <<             refNanoGfexL2Md.ask3_vol             << ",";
    m_fileLevel2Stream << "ask4_px=" <<              refNanoGfexL2Md.ask4_px              << ",";
    m_fileLevel2Stream << "ask4_vol=" <<             refNanoGfexL2Md.ask4_vol             << ",";
    m_fileLevel2Stream << "ask5_px=" <<              refNanoGfexL2Md.ask5_px              << ",";
    m_fileLevel2Stream << "ask5_vol=" <<             refNanoGfexL2Md.ask5_vol             << ",";
    m_fileLevel2Stream << "buy_imply_qty_1=" <<      refNanoGfexL2Md.buy_imply_qty_1      << ",";
    m_fileLevel2Stream << "buy_imply_qty_2=" <<      refNanoGfexL2Md.buy_imply_qty_2      << ",";
    m_fileLevel2Stream << "buy_imply_qty_3=" <<      refNanoGfexL2Md.buy_imply_qty_3      << ",";
    m_fileLevel2Stream << "buy_imply_qty_4=" <<      refNanoGfexL2Md.buy_imply_qty_4      << ",";
    m_fileLevel2Stream << "buy_imply_qty_5=" <<      refNanoGfexL2Md.buy_imply_qty_5      << ",";
    m_fileLevel2Stream << "sell_imply_qty_1=" <<     refNanoGfexL2Md.sell_imply_qty_1     << ",";
    m_fileLevel2Stream << "sell_imply_qty_2=" <<     refNanoGfexL2Md.sell_imply_qty_2     << ",";
    m_fileLevel2Stream << "sell_imply_qty_3=" <<     refNanoGfexL2Md.sell_imply_qty_3     << ",";
    m_fileLevel2Stream << "sell_imply_qty_4=" <<     refNanoGfexL2Md.sell_imply_qty_4     << ",";
    m_fileLevel2Stream << "sell_imply_qty_5=" <<     refNanoGfexL2Md.sell_imply_qty_5     << std::endl;
}