#include "NanoShfeMdApi.h"
#include <cstdio>
#include <cstdlib>
#include <time.h>
#include <thread>
#include <fstream>
#include <arpa/inet.h>

class CNanoShfeMdSpiImpl : public CNanoShfeMdSpi
{
public:
    CNanoShfeMdSpiImpl(int32_t instanceIndex);
    ~CNanoShfeMdSpiImpl();
public:
    virtual void OnNanoShfeMd(const NanoShfeMdType& refSNanoShfeMd);
private:
    int32_t _CreateShowFile();

private:
    std::ofstream           m_fileStream;       //行情落地文件流对象
    int32_t                 m_instanceIndex = 0;
};


void NanoChannelFunc(int32_t instanceIndex)
{
    printf("NanoChannelFunc: %d......start\n", instanceIndex);
    CNanoShfeMdSpiImpl mdSpi(instanceIndex);
    CNanoShfeMdApi& refNanoShfeMdApi = CNanoShfeMdApi::CreateNanoShfeMdApi();

    char szBuf[32] = {};
    sprintf(szBuf, "config_%d.ini", instanceIndex);

    //阻塞示例
    #if 1
    {
        printf("NanoChannelFunc: %d 阻塞模式\n", instanceIndex);
        refNanoShfeMdApi.NanoRecvStart(mdSpi, szBuf);
    }
    #endif

    //非阻塞示例
    #if 0
    {
        printf("NanoChannelFunc: %d 非阻塞模式\n", instanceIndex);
        if (0 != refNanoShfeMdApi.NanoStart(mdSpi, szBuf))
        {
            printf("NanoChannelFunc: %d NanoStart failed\n", instanceIndex);
            return;
        }

        int32_t nRet = -1;
        while (-1 != (nRet = refNanoShfeMdApi.NanoRecv()))
        {
            if (0 == nRet)
            {
                //printf("NanoChannelFunc: %d none dma data\n", instanceIndex);
            }
        }
    }
    #endif

    //非回调示例
    #if 0
    {
        printf("NanoChannelFunc: %d 非回调模式\n", instanceIndex);
        if (0 != refNanoShfeMdApi.NanoStart(szBuf))
        {
            printf("NanoChannelFunc: %d NanoStart failed\n", instanceIndex);
            return;
        }

        NanoShfeMdType nanoShfeMd = {};
        int32_t nRet = -1;
        while (-1 != (nRet = refNanoShfeMdApi.NanoRecv(nanoShfeMd)))
        {
            if (1 == nRet)
            {
                mdSpi.OnNanoShfeMd(nanoShfeMd);
            }
        }
    }
    #endif

	CNanoShfeMdApi::DestroyNanoShfeMdApi(refNanoShfeMdApi);
    printf("NanoChannelFunc: %d......end\n", instanceIndex);
}

int32_t main(int32_t argc, char** argv)
{
    if (argc < 2)
    {
        printf("Usage: %s Count\n", argv[0]);
        return -1;
    }

    int32_t InstanceCount = atoi(argv[1]);
    if ((InstanceCount < 1) || (InstanceCount > 16))
    {
        //Count ∈ [1~16]
        printf("Usage: %s Count ∈ [1~16]\n", argv[0]);
        return -1;
    }

    std::thread threadArray[16];
    for (int32_t index = 0; index < InstanceCount; ++index)
    {
        threadArray[index] = std::thread(NanoChannelFunc, index);
    }
    
    for (int32_t index = 0; index < InstanceCount; ++index)
    {
        threadArray[index].join();
    }

    return 0;
}


CNanoShfeMdSpiImpl::CNanoShfeMdSpiImpl(int32_t instanceIndex)
    : m_instanceIndex(instanceIndex)
{
    _CreateShowFile();
}

CNanoShfeMdSpiImpl::~CNanoShfeMdSpiImpl()
{
    if (m_fileStream.is_open())
    {
        m_fileStream.flush();
        m_fileStream.close();
    }
}

void CNanoShfeMdSpiImpl::OnNanoShfeMd(const NanoShfeMdType& refSNanoShfeMd)
{
    m_fileStream << refSNanoShfeMd.inst_id              << ",";
    m_fileStream << refSNanoShfeMd.update_time          << ",";
    m_fileStream << refSNanoShfeMd.update_milli_sec     << ",";
    m_fileStream << refSNanoShfeMd.change_no            << ",";
    m_fileStream << refSNanoShfeMd.last_px              << ",";
    m_fileStream << refSNanoShfeMd.volume               << ",";
    m_fileStream << refSNanoShfeMd.turnover             << ",";
    m_fileStream << refSNanoShfeMd.open_interest        << ",";
    m_fileStream << refSNanoShfeMd.bid1_px              << ",";
    m_fileStream << refSNanoShfeMd.bid1_vol             << ",";
    m_fileStream << refSNanoShfeMd.bid2_px              << ",";
    m_fileStream << refSNanoShfeMd.bid2_vol             << ",";
    m_fileStream << refSNanoShfeMd.bid3_px              << ",";
    m_fileStream << refSNanoShfeMd.bid3_vol             << ",";
    m_fileStream << refSNanoShfeMd.bid4_px              << ",";
    m_fileStream << refSNanoShfeMd.bid4_vol             << ",";
    m_fileStream << refSNanoShfeMd.bid5_px              << ",";
    m_fileStream << refSNanoShfeMd.bid5_vol             << ",";
    m_fileStream << refSNanoShfeMd.ask1_px              << ",";
    m_fileStream << refSNanoShfeMd.ask1_vol             << ",";
    m_fileStream << refSNanoShfeMd.ask2_px              << ",";
    m_fileStream << refSNanoShfeMd.ask2_vol             << ",";
    m_fileStream << refSNanoShfeMd.ask3_px              << ",";
    m_fileStream << refSNanoShfeMd.ask3_vol             << ",";
    m_fileStream << refSNanoShfeMd.ask4_px              << ",";
    m_fileStream << refSNanoShfeMd.ask4_vol             << ",";
    m_fileStream << refSNanoShfeMd.ask5_px              << ",";
    m_fileStream << refSNanoShfeMd.ask5_vol             << ",";
    m_fileStream << refSNanoShfeMd.bid_volume           << ",";
    m_fileStream << refSNanoShfeMd.bid_amount           << ",";
    m_fileStream << refSNanoShfeMd.ask_volume           << ",";
    m_fileStream << refSNanoShfeMd.ask_amount           << ",";
    m_fileStream << refSNanoShfeMd.high_price           << ",";
    m_fileStream << refSNanoShfeMd.low_price            << ",";
	m_fileStream << refSNanoShfeMd.max_inst_no          << ",";   
	m_fileStream << refSNanoShfeMd.last_tick_flag       << std::endl;
 
}

int32_t CNanoShfeMdSpiImpl::_CreateShowFile()
{
    char file_name[256] = {};
    time_t time_now = {};
    time(&time_now);
    struct tm *tm_now = localtime(&time_now);

    sprintf(file_name, "nano_u50_channel%d_%04d%02d%02d_%02d%02d%02d.csv", m_instanceIndex, tm_now->tm_year + 1900, tm_now->tm_mon + 1, tm_now->tm_mday, tm_now->tm_hour, tm_now->tm_min, tm_now->tm_sec);
    m_fileStream.open(file_name);
    m_fileStream.precision(6);
    m_fileStream.setf(std::ios::uppercase|std::ios::scientific);
    m_fileStream << "inst_id,update_time,update_milli_sec,change_no,last_px,volume,turnover,open_interest,bid1_px,bid1_vol,bid2_px,bid2_vol,bid3_px,bid3_vol,bid4_px,bid4_vol,bid5_px,bid5_vol,ask1_px,ask1_vol,ask2_px,ask2_vol,ask3_px,ask3_vol,ask4_px,ask4_vol,ask5_px,ask5_vol,bid_volume,bid_amount,ask_volume,ask_amount,high_price,low_price,max_inst_no,last_tick_flag" << std::endl;
    return 0;
}