#include "NanoNetShfeMdApi.h"
#include <cstdio>
#include <cstdlib>
#include <time.h>
#include <fstream>
#include <iostream>

class CNanoNetShfeMdSpiImpl : public CNanoNetShfeMdSpi
{
public:
    CNanoNetShfeMdSpiImpl();
    ~CNanoNetShfeMdSpiImpl();
public:
    virtual void OnNanoShfeMd(const NanoShfeMdType& refSNanoShfeMd);

private:
    int32_t _CreateShowFile();

private:
    std::ofstream           m_fileStream;               //落地文件流对象
};

void NanoShfeFunc(const char* lpConfig)
{
    printf("NanoShfeFunc: ......start\n");

    if (nullptr == lpConfig)
    {
        return;
    }

    CNanoNetShfeMdSpiImpl mdSpi = {};
    CNanoNetShfeMdApi& refNanoShfeMdApi = CNanoNetShfeMdApi::CreateNanoShfeMdApi();

    //阻塞示例
    #if 1
    {
        printf("NanoShfeFunc: 阻塞模式\n");
        refNanoShfeMdApi.NanoRecvStart(mdSpi, lpConfig);
    }
    #endif

    //非阻塞示例
    #if 0
    {
        printf("NanoShfeFunc: 非阻塞模式\n");
        if (0 != refNanoShfeMdApi.NanoStart(mdSpi, lpConfig))
        {
            printf("NanoShfeFunc: NanoStart failed\n");
            return;
        }
        
        int32_t nRet = -1;
        while (-1 != (nRet = refNanoShfeMdApi.NanoRecv()))
        {
            if (0 == nRet)
            {
                //printf("NanoShfeFunc: none data\n");
            }
            else if (1 == nRet)
            {
                //printf("NanoShfeFunc: have data\n");
            }
        }
    }
    #endif

	CNanoNetShfeMdApi::DestroyNanoShfeMdApi(refNanoShfeMdApi);
    printf("NanoShfeFunc: ......end\n");
}

int32_t main(int32_t argc, char** argv)
{
    if (argc < 2)
    {
        printf("Usage: %s config.ini\n", argv[0]);
        return -1;
    }

    NanoShfeFunc(argv[1]);

    return 0;
}

CNanoNetShfeMdSpiImpl::CNanoNetShfeMdSpiImpl()
{
    _CreateShowFile();
}

CNanoNetShfeMdSpiImpl::~CNanoNetShfeMdSpiImpl()
{
    if (m_fileStream.is_open())
    {
        m_fileStream.flush();
        m_fileStream.close();
    }
}

int32_t CNanoNetShfeMdSpiImpl::_CreateShowFile()
{
    char file_name[256] = {};
    time_t time_now = {};
    time(&time_now);
    struct tm *tm_now = localtime(&time_now);

    //落地文件
    {
        sprintf(file_name, "nano_udp_%04d%02d%02d_%02d%02d%02d.csv", tm_now->tm_year + 1900, tm_now->tm_mon + 1, tm_now->tm_mday, tm_now->tm_hour, tm_now->tm_min, tm_now->tm_sec);
        m_fileStream.open(file_name);
        m_fileStream.precision(6);
        m_fileStream.setf(std::ios::uppercase|std::ios::scientific);
        m_fileStream << "inst_id,update_time,update_milli_sec,change_no,last_px,volume,turnover,open_interest,bid1_px,bid1_vol,bid2_px,bid2_vol,bid3_px,bid3_vol,bid4_px,bid4_vol,bid5_px,bid5_vol,ask1_px,ask1_vol,ask2_px,ask2_vol,ask3_px,ask3_vol,ask4_px,ask4_vol,ask5_px,ask5_vol,bid_volume,bid_amount,ask_volume,ask_amount,high_price,low_price,max_inst_no,last_tick_flag" << std::endl;
        
    }

    return 0;
}

void CNanoNetShfeMdSpiImpl::OnNanoShfeMd(const NanoShfeMdType& refSNanoShfeMd)
{
    m_fileStream << refSNanoShfeMd.inst_id              << ",";
    m_fileStream << refSNanoShfeMd.update_time          << ",";
    m_fileStream << refSNanoShfeMd.update_milli_sec     << ",";
    m_fileStream << refSNanoShfeMd.change_no            << ",";
    m_fileStream << refSNanoShfeMd.last_px              << ",";
    m_fileStream << refSNanoShfeMd.volume               << ",";
    m_fileStream << refSNanoShfeMd.turnover             << ",";
    m_fileStream << refSNanoShfeMd.open_interest        << ",";
    m_fileStream << refSNanoShfeMd.bid1_px              << ",";
    m_fileStream << refSNanoShfeMd.bid1_vol             << ",";
    m_fileStream << refSNanoShfeMd.bid2_px              << ",";
    m_fileStream << refSNanoShfeMd.bid2_vol             << ",";
    m_fileStream << refSNanoShfeMd.bid3_px              << ",";
    m_fileStream << refSNanoShfeMd.bid3_vol             << ",";
    m_fileStream << refSNanoShfeMd.bid4_px              << ",";
    m_fileStream << refSNanoShfeMd.bid4_vol             << ",";
    m_fileStream << refSNanoShfeMd.bid5_px              << ",";
    m_fileStream << refSNanoShfeMd.bid5_vol             << ",";
    m_fileStream << refSNanoShfeMd.ask1_px              << ",";
    m_fileStream << refSNanoShfeMd.ask1_vol             << ",";
    m_fileStream << refSNanoShfeMd.ask2_px              << ",";
    m_fileStream << refSNanoShfeMd.ask2_vol             << ",";
    m_fileStream << refSNanoShfeMd.ask3_px              << ",";
    m_fileStream << refSNanoShfeMd.ask3_vol             << ",";
    m_fileStream << refSNanoShfeMd.ask4_px              << ",";
    m_fileStream << refSNanoShfeMd.ask4_vol             << ",";
    m_fileStream << refSNanoShfeMd.ask5_px              << ",";
    m_fileStream << refSNanoShfeMd.ask5_vol             << ",";
    m_fileStream << refSNanoShfeMd.bid_volume           << ",";
    m_fileStream << refSNanoShfeMd.bid_amount           << ",";
    m_fileStream << refSNanoShfeMd.ask_volume           << ",";
    m_fileStream << refSNanoShfeMd.ask_amount           << ","; 
	m_fileStream << refSNanoShfeMd.high_price           << ",";
	m_fileStream << refSNanoShfeMd.low_price            << ",";
	m_fileStream << refSNanoShfeMd.max_inst_no          << ",";    
	m_fileStream << refSNanoShfeMd.last_tick_flag       << std::endl;
}