#!/bin/bash
rbffile=$(ls *.rbf)
if [[ -f $(which enyx-firmware-manager) ]];then
    enyx-firmware-manager --board=0 --file_path=${rbffile} --force driver
elif [[ -f $(which enyx-bsp-firmware) ]];then
    enyx-bsp-firmware -a 0 flash ${rbffile}
else
    echo -e "\033[0;33m the driver of the FPGA board was not successfully installed, please contact NANO team for help. \033[0m"
    exit -1
fi

if [[ 0 -ne ${?} ]];then
    echo -e "\033[0;31m Failed to update the firmware of FPGA, please contact NANO team for help. \033[0m"
    exit -1
fi

max_attempts=3
attempt=1
while [ $attempt -le $max_attempts ]; do
    read -p "Finished updating the firmware of the FPGA, would you like to reboot OS now? [y/N] " answer
    case $answer in
        [Yy]*)
            echo -e "\033[0;33m Initiating system reboot... \033[0m"
            sudo reboot
            exit 0
            ;;
        [Nn]*)
            echo -e "\033[0;33m Reboot postponed. \033[0m"
            exit 0
            ;;
        *)
            if [ $attempt -eq $max_attempts ]; then
                echo -e "\033[0;33m Maximum attempts reached. Exiting without reboot. \033[0m"
                exit 1
            else
                echo "Invalid input. Please answer with 'y' or 'n'. You have $((max_attempts - attempt)) attempt(s) remaining."
                ((attempt++))
            fi
            ;;
    esac
done
echo -e "\033[0;33m Finished updating the firmware of the FPGA, please reboot the OS to take affect. \033[0m"