#!/bin/bash

DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

if [ -z "$1" ]
then
    echo "No device specified. use exanic0 as deault."
    NIC="0"
else
    NIC=${1##*c}
fi

EXANIC_RED="$DIR/exablaze-tools --with-nic-id=${NIC} --read-from-reg"

echo -e "~~~~~~~~~~~~~~~~~~~~~ Version Info ~~~~~~~~~~~~~~~~~
Ver Compile Version\t 0x1\t $(${EXANIC_RED}=0x1)
Ver Compile Date\t 0x2\t $(${EXANIC_RED}=0x2)
~~~~~~~~~~~~~~~~~~~~~ States Info ~~~~~~~~~~~~~~~~~
Licensed\t 0x500\t $(${EXANIC_RED}=0x500)
Orginal_data_upload\t 0x200\t $(${EXANIC_RED}=0x200)
Decode_start\t 0x201\t $(${EXANIC_RED}=0x201)
Subscribe_all_ine\t 0x202\t $(${EXANIC_RED}=0x202)
Subscribe_all_shfe\t 0x203\t $(${EXANIC_RED}=0x203)
Packet_no_init\t 0x210\t $(${EXANIC_RED}=0x210)
cnt_upload_fifo0_full\t 0x501\t $(${EXANIC_RED}=0x501)
cnt_upload_fifo1_full\t 0x502\t $(${EXANIC_RED}=0x502)
cnt_frame_mux_fifo0_full\t 0x503\t $(${EXANIC_RED}=0x503)
cnt_frame_mux_fifo1_full\t 0x504\t $(${EXANIC_RED}=0x504)
split_all_field\t 0x576\t $(${EXANIC_RED}=0x576)
~~~~~~~~~~~~~~~~~~~~~ RAW Info ~~~~~~~~~~~~~~~~~
cnt_raw0_in_sop\t 0x510\t $(${EXANIC_RED}=0x510)
cnt_raw1_in_sop\t 0x511\t $(${EXANIC_RED}=0x511)
cnt_raw0_in_err\t 0x514\t $(${EXANIC_RED}=0x514)
cnt_raw1_in_err\t 0x515\t $(${EXANIC_RED}=0x515)
cnt_raw0_in_crc_fail\t 0x518\t $(${EXANIC_RED}=0x518)
cnt_raw1_in_crc_fail\t 0x519\t $(${EXANIC_RED}=0x519)
~~~~~~~~~~~~~~~~~~~~~ Filter Info ~~~~~~~~~~~~~~~~~
cnt_cdc_rx0_sop\t 0x51c\t $(${EXANIC_RED}=0x51c)
cnt_cdc_rx0_eop\t 0x520\t $(${EXANIC_RED}=0x520)
cnt_cdc_rx1_sop\t 0x51d\t $(${EXANIC_RED}=0x51d)
cnt_cdc_rx1_eop\t 0x521\t $(${EXANIC_RED}=0x521)
cnt_filter0_msg\t 0x524\t $(${EXANIC_RED}=0x524)
cnt_filter0_udp\t 0x528\t $(${EXANIC_RED}=0x528)
cnt_filter0_shfe\t 0x52c\t $(${EXANIC_RED}=0x52c)
cnt_filter0_ine\t 0x530\t $(${EXANIC_RED}=0x530)
cnt_filter1_msg\t 0x525\t $(${EXANIC_RED}=0x525)
cnt_filter1_udp\t 0x529\t $(${EXANIC_RED}=0x529)
cnt_filter1_shfe\t 0x52d\t $(${EXANIC_RED}=0x52d)
cnt_filter1_ine\t 0x531\t $(${EXANIC_RED}=0x531)
~~~~~~~~~~~~~~~~~~~~~ SHFE Info ~~~~~~~~~~~~~~~~~
mux0_packet0_no\t 0x540\t $(${EXANIC_RED}=0x540)
mux0_packet1_no\t 0x542\t $(${EXANIC_RED}=0x542)
mux0_packet_no\t 0x548\t $(${EXANIC_RED}=0x548)
cnt_mux0_udp0_vld\t 0x534\t $(${EXANIC_RED}=0x534)
cnt_mux0_udp1_vld\t 0x536\t $(${EXANIC_RED}=0x536)
cnt_mux0_mirp\t 0x53c\t $(${EXANIC_RED}=0x53c)
cnt_mux0_crowded\t 0x54a\t $(${EXANIC_RED}=0x54a)
cnt_mux0_lane0_select\t 0x54c\t $(${EXANIC_RED}=0x54c)
cnt_mux0_lane1_select\t 0x54e\t $(${EXANIC_RED}=0x54e)
cnt_field_sop[0]\t 0x550\t $(${EXANIC_RED}=0x550)
cnt_field_eop[0]\t 0x552\t $(${EXANIC_RED}=0x552)
cnt_split_instrument_end[0]\t 0x554\t $(${EXANIC_RED}=0x554)
cnt_instrument_vld[0]\t 0x556\t $(${EXANIC_RED}=0x556)
cnt_price_change_vld[0]\t 0x558\t $(${EXANIC_RED}=0x558)
cnt_deal_change_vld[0]\t 0x55a\t $(${EXANIC_RED}=0x55a)
cnt_bid_msg_change_vld[0]\t 0x572\t $(${EXANIC_RED}=0x572)
cnt_ask_msg_change_vld[0]\t 0x574\t $(${EXANIC_RED}=0x574)
cnt_parser_instrument_end[0]\t 0x55c\t $(${EXANIC_RED}=0x55c)
cnt_subscribe_shfe\t 0x55e\t $(${EXANIC_RED}=0x55e)
~~~~~~~~~~~~~~~~~~~~~ INE Info ~~~~~~~~~~~~~~~~~
mux1_packet0_no\t 0x541\t $(${EXANIC_RED}=0x541)
mux1_packet1_no\t 0x543\t $(${EXANIC_RED}=0x543)
mux1_packet_no\t 0x549\t $(${EXANIC_RED}=0x549)
cnt_mux1_udp0_vld\t 0x535\t $(${EXANIC_RED}=0x535)
cnt_mux1_udp1_vld\t 0x537\t $(${EXANIC_RED}=0x537)
cnt_mux1_mirp\t 0x53d\t $(${EXANIC_RED}=0x53d)
cnt_mux1_crowded\t 0x54b\t $(${EXANIC_RED}=0x54b)
cnt_mux1_lane0_select\t 0x54d\t $(${EXANIC_RED}=0x54d)
cnt_mux1_lane1_select\t 0x54f\t $(${EXANIC_RED}=0x54f)
cnt_field_sop[1]\t 0x551\t $(${EXANIC_RED}=0x551)
cnt_field_eop[1]\t 0x553\t $(${EXANIC_RED}=0x553)
cnt_split_instrument_end[1]\t 0x555\t $(${EXANIC_RED}=0x555)
cnt_instrument_vld[1]\t 0x557\t $(${EXANIC_RED}=0x557)
cnt_price_change_vld[1]\t 0x559\t $(${EXANIC_RED}=0x559)
cnt_deal_change_vld[1]\t 0x55b\t $(${EXANIC_RED}=0x55b)
cnt_bid_msg_change_vld[0]\t 0x573\t $(${EXANIC_RED}=0x573)
cnt_ask_msg_change_vld[0]\t 0x575\t $(${EXANIC_RED}=0x575)
cnt_parser_instrument_end[1]\t 0x55d\t $(${EXANIC_RED}=0x55d)
cnt_subscribe_ine\t 0x55f\t $(${EXANIC_RED}=0x55f)
~~~~~~~~~~~~~~~~~~~~~ Upload Info ~~~~~~~~~~~~~~~~~
cnt_upload_shfe_sof\t 0x560\t $(${EXANIC_RED}=0x560)
cnt_upload_shfe_eof\t 0x561\t $(${EXANIC_RED}=0x561)
cnt_upload_ine_sof\t 0x562\t $(${EXANIC_RED}=0x562)
cnt_upload_ine_eof\t 0x563\t $(${EXANIC_RED}=0x563)
cnt_upload_sof\t 0x564\t $(${EXANIC_RED}=0x564)
cnt_upload_eof\t 0x565\t $(${EXANIC_RED}=0x565)
cnt_frame_mux_i0_sof\t 0x566\t $(${EXANIC_RED}=0x566)
cnt_frame_mux_i0_eof\t 0x567\t $(${EXANIC_RED}=0x567)
cnt_frame_mux_i1_sof\t 0x568\t $(${EXANIC_RED}=0x568)
cnt_frame_mux_i1_eof\t 0x569\t $(${EXANIC_RED}=0x569)
cnt_frame_mux_o_sof\t 0x56a\t $(${EXANIC_RED}=0x56a) 
cnt_frame_mux_o_eof\t 0x56b\t $(${EXANIC_RED}=0x56b)
~~~~~~~~~~~~~~~~~~~~~ DMA Info ~~~~~~~~~~~~~~~~~
cnt_dma0_out_sop\t 0x570\t $(${EXANIC_RED}=0x570)
cnt_dma0_out_eop\t 0x571\t $(${EXANIC_RED}=0x571)" | sh $DIR/table -15 -red,-green,-blue
