#ifndef COMMONHDR
#define COMMONHDR
#include <stdint.h>
#ifdef _TCP_DECODE
#include "tcpheader.h"
#endif
#ifdef _UDP_DECODE
#include "udpheader.h"
#endif
#define SHM_CNT 9216


typedef struct __attribute__((packed, aligned(1)))instrument {
//typedef struct instrument {
    uint8_t     inst_id[16];            // 合约编码, 例如: ag2201
    double      last_px;                // 最新成交价       
    uint32_t    volume;                 // 最新成交量
    uint32_t    update_time;            // 该笔行情更新时间-秒数,Linux epoch时间戳格式
    uint16_t    update_milli_sec;       // 该笔行情更新时间-毫秒.上期所取值有0和500两种类型
    uint16_t    type;                   // 合约数据类型(0:上期 1:能源)
    uint32_t    change_no;              // 合约行情的编号,每个合约独立编号, 连续递增
    double      turnover;               // 成交总量
    double      open_interest;          // 未平仓总量
    int32_t     bid_totvol;             // 买报单总量(beta)
    int32_t     ask_totvol;             // 卖报单总量(beta)
    double      bid_totamount;          // 买报单总金额(beta)
    double      ask_totamount;          // 卖报单总金额(beta)

    double      bid_px[10];             // 买一至买五价格.后五个档位数据无意义.
    int32_t     bid_vol[10];            // 买一至买无量.  后五个档位数据无意义.
    int32_t     ask_vol[10];            // 卖一至卖五价格.后五个档位数据无意义.
    double      ask_px[10];             // 卖一至卖无量.  后五个档位数据无意义.
}instrument_t;

#define OFFSET_LP   16                  // instrument_t 结构体中last_px的偏移量
#define OFFSET_VOL  24                  // instrument_t 结构体中volume的偏移量
#define OFFSET_UT   28                  // instrument_t 结构体中update_time的偏移量
#define OFFSET_UMS  32                  // instrument_t 结构体中update_milli_sec的偏移量
#define OFFSET_CN   36                  // instrument_t 结构体中change_no的偏移量
#define OFFSET_TO   40                  // instrument_t 结构体中turnover的偏移量
#define OFFSET_OI   48                  // instrument_t 结构体中open_interest的偏移量

/* 内存中存储的所有合约信息结构*/
typedef struct share {
    struct instrument   instmts[SHM_CNT];
    int32_t             shfe_inst_cnt; // 上期所合约个数
    int32_t             ine_inst_cnt;   // 能源所合约个数
    int32_t             shfe_pktno;     // 上期快照包序号
    int32_t             ine_pktno;      // 能源快照包序号
}share_t;

#endif
