#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <time.h>
#include <emmintrin.h>
#include "commonheader.h"


volatile uint16_t *ringbuf;
uint16_t indx = 0;
struct instrument *insts;

/* 运行标记,为0时停止运行 */
int keep_running = 1;
FILE* dumpHandler;

int init_connector(struct instrument **insts, volatile uint16_t **ringbuf);
void free_mem(char *mem);

void sig_handler(int sig)
{
    keep_running = 0;
    fflush(stdout);
    printf("received Ctrl + C signal.\n");
}

int main()
{
    signal(SIGINT, sig_handler);
    struct instrument *insts;
    volatile uint16_t *ringbuf;
    init_connector(&insts, &ringbuf);

    time_t rawtime;
    time(&rawtime);
    struct tm *timeinfo = localtime(&rawtime);
    char log_name[256] = {};
    sprintf(log_name, "exanic_md_%04d%02d%02d_%02d%02d%02d.csv", timeinfo->tm_year + 1900, timeinfo->tm_mon + 1, timeinfo->tm_mday, timeinfo->tm_hour, timeinfo->tm_min, timeinfo->tm_sec);

    /* 打开一个csv文件 */
    dumpHandler = fopen(log_name, "w");
    if (!dumpHandler)
    {
        printf("fopen: %s failed\n", log_name);
        return -1;
    }

    printf("start dump insts data in %s\n", log_name);

    /* 找到最新的一个合约，防止读到旧数据*/
    while (keep_running)
    {
        if (ringbuf[indx++] == 0xffff)
            break;
    }

    /* 写csv文件标题 */
    fprintf(dumpHandler, "type,inst_id,update_time,update_milli_sec,change_no,last_px,volume,turnover,open_interest,\
bid1_volume,bid1_price,bid2_volume,bid2_price,bid3_volume,bid3_price,bid4_volume,bid4_price,bid5_volume,bid5_price,\
ask1_volume,ask1_price,ask2_volume,ask2_price,ask3_volume,ask3_price,ask4_volume,ask4_price,ask5_volume,ask5_price,\
bid_volume,bid_amount,ask_volume,ask_amount\n");

    --indx;

    /* 阻塞读取数据，直至Ctrl+C终止*/
    int inst_idx = 0;
    while(keep_running)
    {
        /* 检测行情是否有更新，若无更新，则ringbuf指向0xffff，否则指向对应更新的合约编号 */
        if ((inst_idx = ringbuf[indx]) != 0xffff)
        {
            /* 可将该行情数据加载至CPU缓存中, 以下示例将数据加载到L2缓存中*/
            _mm_prefetch(((char *)insts[inst_idx].inst_id), _MM_HINT_T1);
            /* 行情输出至csv文件，也可以在此实现其它处理 */
            fprintf(dumpHandler, "%u,%s,%u,%d,%d,%.2f,%d,%.2f,%.2f,%d,%.2f,%d,%.2f,%d,%.2f,%d,%.2f,%d,%.2f,%d,%.2f,%d,%.2f,%d,%.2f,%d,%.2f,%d,%.2f,%d,%.2f,%d,%.2f\n",
                insts[inst_idx].type, insts[inst_idx].inst_id, insts[inst_idx].update_time, insts[inst_idx].update_milli_sec, insts[inst_idx].change_no,
                insts[inst_idx].last_px, insts[inst_idx].volume, insts[inst_idx].turnover, insts[inst_idx].open_interest,
                insts[inst_idx].bid_vol[0], insts[inst_idx].bid_px[0], insts[inst_idx].bid_vol[1], insts[inst_idx].bid_px[1], insts[inst_idx].bid_vol[2],
                insts[inst_idx].bid_px[2], insts[inst_idx].bid_vol[3], insts[inst_idx].bid_px[3], insts[inst_idx].bid_vol[4], insts[inst_idx].bid_px[4],
                insts[inst_idx].ask_vol[0], insts[inst_idx].ask_px[0], insts[inst_idx].ask_vol[1], insts[inst_idx].ask_px[1], insts[inst_idx].ask_vol[2],
                insts[inst_idx].ask_px[2], insts[inst_idx].ask_vol[3], insts[inst_idx].ask_px[3], insts[inst_idx].ask_vol[4], insts[inst_idx].ask_px[4],
                insts[inst_idx].bid_totvol, insts[inst_idx].bid_totamount, insts[inst_idx].ask_totvol, insts[inst_idx].ask_totamount);
            fflush(dumpHandler);
                            
            /* indx 为uint16_t类型，无符号整数，至0xffff最大值继续+1后会变为0，以此往复循环形成一个环*/
            ++indx;
        }
    }

    fclose(dumpHandler);
    free_mem((char *)insts);
    return 0;
}
