/**
 * Kernel support for the ExaSock library
 * Copyright (C) 2011-2017 Exablaze Pty Ltd and its licensors
 */

#ifndef _EXASOCK_GENL_H_
#define _EXASOCK_GENL_H_

#define EXASOCK_GENL_NAME   "exasock"
#define EXASOCK_GENL_VER    0x1

/* Values */

enum exasock_genl_sock_type
{
    EXASOCK_GENL_SOCKTYPE_TCP_LISTEN,
    EXASOCK_GENL_SOCKTYPE_TCP_CONN,
    EXASOCK_GENL_SOCKTYPE_UDP_LISTEN,
    EXASOCK_GENL_SOCKTYPE_UDP_CONN,

    __EXASOCK_GENL_SOCKTYPE_MAX,
};
#define EXASOCK_GENL_SOCKTYPE_MAX (__EXASOCK_GENL_SOCKTYPE_MAX - 1)

enum exasock_genl_conn_state
{
    EXASOCK_GENL_CONNSTATE_CLOSED,
    EXASOCK_GENL_CONNSTATE_LISTEN,
    EXASOCK_GENL_CONNSTATE_SENT,
    EXASOCK_GENL_CONNSTATE_RCVD,
    EXASOCK_GENL_CONNSTATE_ESTABLISHED,
    EXASOCK_GENL_CONNSTATE_CLOSE_WAIT,
    EXASOCK_GENL_CONNSTATE_FIN_WAIT_1,
    EXASOCK_GENL_CONNSTATE_FIN_WAIT_2,
    EXASOCK_GENL_CONNSTATE_CLOSING,
    EXASOCK_GENL_CONNSTATE_LAST_ACK,
    EXASOCK_GENL_CONNSTATE_TIME_WAIT,
    EXASOCK_GENL_CONNSTATE_NONE,

    __EXASOCK_GENL_CONNSTATE_MAX,
};
#define EXASOCK_GENL_CONNSTATE_MAX (__EXASOCK_GENL_CONNSTATE_MAX - 1)

/* Commands */

enum
{
    EXASOCK_GENL_C_GET_SOCKLIST,
    EXASOCK_GENL_C_GET_SOCKET,

    __EXASOCK_GENL_C_MAX,
};
#define EXASOCK_GENL_C_MAX (__EXASOCK_GENL_C_MAX - 1)

/* Attributes */

enum
{
    EXASOCK_GENL_A_UNSPEC,
    EXASOCK_GENL_A_SOCK_TYPE,       /* u8 (enum exasock_genl_sock_type) */
    EXASOCK_GENL_A_SOCK_EXTENDED,   /* flag */
    EXASOCK_GENL_A_SOCK_INTERNAL,   /* flag */
    EXASOCK_GENL_A_SOCK_PID,        /* u32 */
    EXASOCK_GENL_A_SOCK_FD,         /* u32 */
    EXASOCK_GENL_A_LIST_SOCK,       /* nest */
    EXASOCK_GENL_A_SINGLE_SOCK,     /* nest */

    __EXASOCK_GENL_A_MAX,
};
#define EXASOCK_GENL_A_MAX (__EXASOCK_GENL_A_MAX - 1)

enum
{
    EXASOCK_GENL_A_ELEM_SOCK_UNSPEC,
    EXASOCK_GENL_A_ELEM_SOCK,                       /* nest */

    __EXASOCK_GENL_A_ELEM_SOCK_MAX,
};
#define EXASOCK_GENL_A_ELEM_SOCK_MAX (__EXASOCK_GENL_A_ELEM_SOCK_MAX - 1)

enum
{
    EXASOCK_GENL_A_SKINFO_UNSPEC,
    EXASOCK_GENL_A_SKINFO_LOCAL_ADDR,               /* u32 */
    EXASOCK_GENL_A_SKINFO_PEER_ADDR,                /* u32 */
    EXASOCK_GENL_A_SKINFO_LOCAL_PORT,               /* u16 */
    EXASOCK_GENL_A_SKINFO_PEER_PORT,                /* u16 */
    EXASOCK_GENL_A_SKINFO_RECV_Q,                   /* u32 */
    EXASOCK_GENL_A_SKINFO_SEND_Q,                   /* u32 */
    EXASOCK_GENL_A_SKINFO_STATE,                    /* u8 */
    EXASOCK_GENL_A_SKINFO_EXTENDED,                 /* nest */
    EXASOCK_GENL_A_SKINFO_INTERN_CONN,              /* nest */
    EXASOCK_GENL_A_SKINFO_INTERN_LISTEN,            /* nest */

    __EXASOCK_GENL_A_SKINFO_MAX,
};
#define EXASOCK_GENL_A_SKINFO_MAX (__EXASOCK_GENL_A_SKINFO_MAX - 1)

enum
{
    EXASOCK_GENL_A_SKINFOEXT_UNSPEC,
    EXASOCK_GENL_A_SKINFOEXT_UID,                   /* u32 */
    EXASOCK_GENL_A_SKINFOEXT_PID,                   /* u32 */
    EXASOCK_GENL_A_SKINFOEXT_FD,                    /* u32 */
    EXASOCK_GENL_A_SKINFOEXT_PROG,                  /* string */

    __EXASOCK_GENL_A_SKINFOEXT_MAX,
};
#define EXASOCK_GENL_A_SKINFOEXT_MAX (__EXASOCK_GENL_A_SKINFOEXT_MAX - 1)

enum
{
    EXASOCK_GENL_A_SKINFOINTC_UNSPEC,
    EXASOCK_GENL_A_SKINFOINTC_TX_BYTES,             /* u64 */
    EXASOCK_GENL_A_SKINFOINTC_TX_ACK_BYTES,         /* u64 */
    EXASOCK_GENL_A_SKINFOINTC_RX_BYTES,             /* u64 */
    EXASOCK_GENL_A_SKINFOINTC_RX_DLVR_BYTES,        /* u64 */
    EXASOCK_GENL_A_SKINFOINTC_RETRANS_SEGS_FAST,    /* u32 */
    EXASOCK_GENL_A_SKINFOINTC_RETRANS_SEGS_TO,      /* u32 */
    EXASOCK_GENL_A_SKINFOINTC_RETRANS_BYTES,        /* u32 */
    EXASOCK_GENL_A_SKINFOINTC_LOCAL_WSCALE,         /* u8 */
    EXASOCK_GENL_A_SKINFOINTC_PEER_WSCALE,          /* u8 */
    EXASOCK_GENL_A_SKINFOINTC_LOCAL_WIN,            /* u32 */
    EXASOCK_GENL_A_SKINFOINTC_PEER_WIN,             /* u32 */
    EXASOCK_GENL_A_SKINFOINTC_LOCAL_MSS,            /* u16 */
    EXASOCK_GENL_A_SKINFOINTC_PEER_MSS,             /* u16 */
    EXASOCK_GENL_A_SKINFOINTC_CWND,                 /* u32 */
    EXASOCK_GENL_A_SKINFOINTC_SSTHRESH,             /* u32 */

    EXASOCK_GENL_A_SKINFOINTC_PAD,                  /* padding */

    __EXASOCK_GENL_A_SKINFOINTC_MAX,
};
#define EXASOCK_GENL_A_SKINFOINTC_MAX (__EXASOCK_GENL_A_SKINFOINTC_MAX - 1)

enum
{
    EXASOCK_GENL_A_SKINFOINTL_UNSPEC,
    EXASOCK_GENL_A_SKINFOINTL_REQS_RCV,             /* u32 */
    EXASOCK_GENL_A_SKINFOINTL_REQS_ESTAB,           /* u32 */

    __EXASOCK_GENL_A_SKINFOINTL_MAX,
};
#define EXASOCK_GENL_A_SKINFOINTL_MAX (__EXASOCK_GENL_A_SKINFOINTL_MAX - 1)

#endif /* _EXASOCK_GENL_H_ */
