#!/bin/bash

if [[ -z "$1" ]];then
    echo "Please specify target install exchange." 
	echo "eg: ${0} shfe/dce/gfex/czce/cffex" && exit 1
fi

if [[ -z $(lspci | grep -i enyx) ]];then
	echo "The U50 board was not loaded properly. Please check if the board is properly inserted or try rebooting and reloading" && exit 1
fi

CurrDir=$(pwd)
if [[ ! -d "${CurrDir}/fw" ]] || [[ ! -d "${CurrDir}/utils" ]] || [[ ! -d "${CurrDir}/sample-code" ]];then
	echo "It has already been installed. Please clear the scheduled tasks before reinstalling and unzip the installation package to reinstall and deploy" && exit 1
fi

NanoDir="/root/nano_u50_${1}"
if [[ -d "${NanoDir}" ]];then
	mv ${NanoDir} ${NanoDir}_$(date +'%Y%m%d_%H%M%S')
fi
mkdir ${NanoDir}
mv sample-code utils Readme.txt ${NanoDir}

# gen show_reg shell script，and install crontab
cd ${NanoDir}/utils/reg
cat <<EOF > show_reg.sh
#!/bin/bash
(date +'%Y-%m-%d %H:%M:%S' && ${NanoDir}/utils/reg/nano_state xilinx0 cat) >> ${NanoDir}/utils/reg/reg_\$(date +'%Y-%m-%d').log
EOF
cat <<EOF > fpga_reset.sh
#!/bin/bash
enyx-cores-example-hw-top-reset 0
enyx-hfp-bus-reset 0
EOF
cat <<EOF > cron
0 6,18 * * 1-5 ${NanoDir}/utils/reg/fpga_reset.sh
20-22 3,8,10,12,15,20 * * 1-6 ${NanoDir}/utils/reg/show_reg.sh
0-10,50-59 8,9,20,21 * * 1-6 ${NanoDir}/utils/reg/show_reg.sh
EOF

serverName="crond"
cronDir="/var/spool/cron/root"
source /etc/os-release
if [[ "ubuntu" == ${ID} ]];then
	serverName="cron"
	cronDir="/var/spool/cron/crontabs/root"
	lsb_release -a
fi

if [[ -f ${cronDir} ]];then
	cat cron >> ${cronDir}
else
	crontab cron
fi
chmod +x ${NanoDir}/utils/reg/*

chown root.root ${NanoDir} -R
systemctl enable ${serverName}
systemctl start ${serverName}
echo "${serverName} service is $(systemctl is-enabled ${serverName})"

cd ${NanoDir}/sample-code/demo
#make clean && make
./run.sh 2&> test.log &
sleep 3
skill api

echo "please tell luis the following info."
echo $(grep DNA test.log | head -n 1)
echo $(ip a | grep inet | awk '{print $2}')

RED='\033[0;31m'
YELLOW='\033[0;33m'
NC='\033[0m'
echo -e "-------------------------------------------------------------------------------------------------------------------------"
echo -e "${YELLOW}                                           升级注意事项                                           ${NC}"
echo -e "${RED}    1. 请确保固件和软件都有配套更新${NC}"
echo -e "${RED}    2. 如果是多次安装或升级，请删除重复历史定时任务（可能会导致板卡识别不到）${NC}"
echo -e "${RED}    3. 用输出DNA前往 \"https://www.nanoexpress.com/license\" 页面查询license并更新到config配置中${NC}"
echo -e "${RED}    4. 参考示例代码 \"/root/nano_u50_xxxx/sample-code\" 开发，策略程序更新interface、lib和config，重新编译策略程序项${NC}\n"
echo -e "${RED}    详细升级操作步骤请参阅 \"https://www.nanoexpress.com/?p=950\"${NC}"
echo -e "-------------------------------------------------------------------------------------------------------------------------"
echo -e "-------------------------------------------------------------------------------------------------------------------------"
echo -e "${YELLOW}                                           Upgrade Notes                                           ${NC}"
echo -e "${RED}    1. Ensure that both the firmware and software are updated together.${NC}"
echo -e "${RED}    2. If performing multiple installations or upgrades, delete duplicate historical scheduled tasks (this may cause the board to fail to be recognized).${NC}"
echo -e "${RED}    3. Use the output DNA to visit the page \"https://www.nanoexpress.com/license\" to query the license and update it in the config file.${NC}"
echo -e "${RED}    4. Refer to the sample code \"/root/nano_u50_xxxx/sample-code\" for development. Update the interface, lib, and config for the strategy program, and recompile the strategy program.${NC}\n"
echo -e "${RED}    For detailed upgrade steps, please refer to \"https://www.nanoexpress.com/?p=950\".${NC}"
echo -e "-------------------------------------------------------------------------------------------------------------------------"

#clear fw
cd ${CurrDir}
rm -rf fw
