#!/bin/bash

# 输出文件名
output_file="output_values_111.txt"
cleaned_file="cleaned_output_values_comb.txt"
# 清空文件内容（如果文件已存在）
> "$output_file"

# 初始化起始值
start_value=0

# 外层循环控制 3000 次（读取 69634 和 69635）
for ((cycle=0; cycle<3000; cycle++)); do
    # 存储当前组的值
    values=()
    
    # 内层循环读取连续 5 个值
    for ((i=0; i<5; i++)); do
        # 当前值
        current_value=$((start_value + i))
        
        # 设置通道值
        ./pio_ctrl 69634 $current_value
        
        # 获取读取的值，并去掉 "69635 :"
        value=$(./pio_ctrl 69635 | sed 's/^69635 : //')
        
        # 保存值到数组
        values+=("$value")
    done
    
    # 处理通道号和合约号
    channel=${values[0]}                                  # 第一个值是通道号
    contract="${values[4]}${values[3]}${values[2]}${values[1]}" # 后四个值倒序组合成合约号

    # 将合约号（十六进制）转换为 ASCII 字符
    ascii_contract=$(echo "$contract" | xxd -r -p 2>/dev/null)

    # 保存到文件
    echo "Channel: $channel, ASCII Contract: $ascii_contract" >> "$output_file"
    
    # 更新起始值，每次增加 64
    start_value=$((start_value + 64))
done

echo "所有通道号和 ASCII 合约号（69634 和 69635）已存入 $output_file"

# 初始化起始值
start_value=0

# 外层循环控制 1000 次（读取 73730 和 73731）
for ((cycle=0; cycle<1000; cycle++)); do
    # 存储当前组的值
    values=()
    
    # 内层循环读取连续 5 个值
    for ((i=0; i<5; i++)); do
        # 当前值
        current_value=$((start_value + i))
        
        # 设置通道值
        ./pio_ctrl 73730 $current_value
        
        # 获取读取的值，并去掉 "73731 :"
        value=$(./pio_ctrl 73731 | sed 's/^73731 : //')
        
        # 保存值到数组
        values+=("$value")
    done
    
    # 处理通道号和合约号
    channel=${values[0]}                                  # 第一个值是通道号
    contract="${values[4]}${values[3]}${values[2]}${values[1]}" # 后四个值倒序组合成合约号

    # 将合约号（十六进制）转换为 ASCII 字符
    ascii_contract=$(echo "$contract" | xxd -r -p 2>/dev/null)

    # 保存到文件
    echo "Channel: $channel, ASCII Contract: $ascii_contract" >> "$output_file"
    
    # 更新起始值，每次增加 64
    start_value=$((start_value + 64))
done

echo "所有通道号和 ASCII 合约号（73730 和 73731）已存入 $output_file"

# --------------------------
# 删除无用的行并保存到新文件
# --------------------------

# 使用 grep 删除只包含 "Channel: 00000000, ASCII Contract:" 的行
grep -v 'Channel: 00000000, ASCII Contract:' "$output_file" > "$cleaned_file"

echo "所有通道号和 ASCII 合约号已存入 $cleaned_file，删除了无用的行。"


