#pragma once

#include <cstdint>
#include <cstdio>

#pragma pack(1)
/******************************************************五档行情******************************************************/
// 五档单腿行情
struct NanoZceL2MdType
{
    uint32_t  contract_no;          // 合约编号
    char      contract_name[20];    // 合约名称
    uint32_t  decimal;              // 价格精度
    int32_t   last_price;           // 最新价		 	（实际价格需要除以精度decimal, 无效数值是0x7FFFFFFF）
    uint32_t  match_qty;            // 成交量
    uint32_t  open_interest;        // 持仓量
    int32_t   derive_bid_price;     // 组合买入价		（实际价格需要除以精度decimal, 无效数值是0x7FFFFFFF）
    int32_t   derive_ask_price;     // 组合卖出价		（实际价格需要除以精度decimal, 无效数值是0x7FFFFFFF）
    uint32_t  derive_bid_qty;       // 组合买入数量
    uint32_t  derive_ask_qty;       // 组合卖出数量
    int32_t   avg_price;            // 平均价		  	（实际价格需要除以精度decimal, 无效数值是0x7FFFFFFF）
    uint32_t  update_time;          // 更新时间秒（Linux epoch时间戳格式）
    uint32_t  update_micro_sec;     // 更新时间微秒（交易所行情毫秒时间精确到微妙，如：250000、500000、750000）
    int64_t   turn_over;            // 总成交金额   		（实际价格需要除以精度decimal, 无效数值是0x7FFFFFFFFFFFFFFF）
    int32_t   limit_up_price;       // 当前未开放为0 涨停价 life high（实际价格需要除以精度decimal, 无效数值是0x7FFFFFFF）
    int32_t   limit_down_price;     // 当前未开放为0 跌停价 life low       （实际价格需要除以精度decimal, 无效数值是0x7FFFFFFF）
    uint32_t  total_bid_qty;        // 总买量
    int32_t   bid_avg_price;        // 买均价			（实际价格需要除以精度decimal, 无效数值是0x7FFFFFFF）
    uint32_t  total_ask_qty;        // 总卖量
    int32_t   ask_avg_price;        // 卖均价			（实际价格需要除以精度decimal, 无效数值是0x7FFFFFFF）
    uint32_t  deep_decimal;         // 深度价格精度（按照交易所文档decimal和deep_decimal可能会不一致，分开两个精度除数上送）
    int32_t   bid_price_1;          // 买一价			（实际价格需要除以精度deep_decimal, 无效数值是0x7FFFFFFF）
    uint32_t  bid_qty_1;            // 买一量
    uint32_t  bid_order_1;          // 买一订单数
    int32_t   ask_price_1;          // 卖一价			（实际价格需要除以精度deep_decimal, 无效数值是0x7FFFFFFF）
    uint32_t  ask_qty_1;            // 卖一量
    uint32_t  ask_order_1;          // 卖一订单数
    int32_t   bid_price_2;          // 买二价			（实际价格需要除以精度deep_decimal, 无效数值是0x7FFFFFFF）
    uint32_t  bid_qty_2;            // 买二量
    uint32_t  bid_order_2;          // 买二订单数
    int32_t   ask_price_2;          // 卖二价			（实际价格需要除以精度deep_decimal, 无效数值是0x7FFFFFFF）
    uint32_t  ask_qty_2;            //卖二量
    uint32_t  ask_order_2;          // 卖二订单数
    int32_t   bid_price_3;          // 买三价			（实际价格需要除以精度deep_decimal, 无效数值是0x7FFFFFFF）
    uint32_t  bid_qty_3;            // 买三量
    uint32_t  bid_order_3;          // 买三订单数
    int32_t   ask_price_3;          // 卖三价			（实际价格需要除以精度deep_decimal, 无效数值是0x7FFFFFFF）
    uint32_t  ask_qty_3;            // 卖三量
    uint32_t  ask_order_3;          // 卖三订单数
    int32_t   bid_price_4;          // 买四价			（实际价格需要除以精度deep_decimal, 无效数值是0x7FFFFFFF）
    uint32_t  bid_qty_4;            // 买四量
    uint32_t  bid_order_4;          // 买四订单数
    int32_t   ask_price_4;          // 卖四价			（实际价格需要除以精度deep_decimal, 无效数值是0x7FFFFFFF）
    uint32_t  ask_qty_4;            // 卖四量
    uint32_t  ask_order_4;          // 卖四订单数
    int32_t   bid_price_5;          // 买五价			（实际价格需要除以精度deep_decimal, 无效数值是0x7FFFFFFF）
    uint32_t  bid_qty_5;            // 买五量
    uint32_t  bid_order_5;          // 买五订单数
    int32_t   ask_price_5;          // 卖五价			（实际价格需要除以精度deep_decimal, 无效数值是0x7FFFFFFF）
    uint32_t  ask_qty_5;            // 卖五量
    uint32_t  ask_order_5;          // 卖五订单数
};

// 五档组合行情
struct NanoZceL2ArbMdType
{
    uint32_t  contract_no;          // 合约编码
    char      contract_name[20];    // 合约名称
    uint32_t  total_bid_qty;        // 总买量
    uint32_t  total_ask_qty;        // 总卖量
    uint32_t  update_time;          // 更新时间秒（Linux epoch时间戳格式）
    uint32_t  update_micro_sec;     // 更新时间微秒（交易所行情毫秒时间精确到微妙，如：250000、500000、750000）
	uint32_t  deep_decimal;         // 深度价格精度（按照交易所文档decimal和deep_decimal可能会不一致，分开两个精度除数上送）
    int32_t   bid_price_1;          // 买一价			（实际价格需要除以精度deep_decimal, 无效数值是0x7FFFFFFF）
    uint32_t  bid_qty_1;            // 买一量
    uint32_t  bid_order_1;          // 买一订单数
    int32_t   ask_price_1;          // 卖一价			（实际价格需要除以精度deep_decimal, 无效数值是0x7FFFFFFF）
    uint32_t  ask_qty_1;            // 卖一量
    uint32_t  ask_order_1;          // 卖一订单数
    int32_t   bid_price_2;          // 买二价			（实际价格需要除以精度deep_decimal, 无效数值是0x7FFFFFFF）
    uint32_t  bid_qty_2;            // 买二量
    uint32_t  bid_order_2;          // 买二订单数
    int32_t   ask_price_2;          // 卖二价			（实际价格需要除以精度deep_decimal, 无效数值是0x7FFFFFFF）
    uint32_t  ask_qty_2;            // 卖二量
    uint32_t  ask_order_2;          // 卖二订单数
    int32_t   bid_price_3;          // 买三价			（实际价格需要除以精度deep_decimal, 无效数值是0x7FFFFFFF）
    uint32_t  bid_qty_3;            // 买三量
    uint32_t  bid_order_3;          // 买三订单数
    int32_t   ask_price_3;          // 卖三价			（实际价格需要除以精度deep_decimal, 无效数值是0x7FFFFFFF）
    uint32_t  ask_qty_3;            // 卖三量
    uint32_t  ask_order_3;          // 卖三订单数
    int32_t   bid_price_4;          // 买四价			（实际价格需要除以精度deep_decimal, 无效数值是0x7FFFFFFF）
    uint32_t  bid_qty_4;            // 买四量
    uint32_t  bid_order_4;          // 买四订单数
    int32_t   ask_price_4;          // 卖四价			（实际价格需要除以精度deep_decimal, 无效数值是0x7FFFFFFF）
    uint32_t  ask_qty_4;            // 卖四量
    uint32_t  ask_order_4;          // 卖四订单数
    int32_t   bid_price_5;          // 买五价			（实际价格需要除以精度deep_decimal, 无效数值是0x7FFFFFFF）
    uint32_t  bid_qty_5;            // 买五量
    uint32_t  bid_order_5;          // 买五订单数
    int32_t   ask_price_5;          // 卖五价			（实际价格需要除以精度deep_decimal, 无效数值是0x7FFFFFFF）
    uint32_t  ask_qty_5;            // 卖五量
    uint32_t  ask_order_5;          // 卖五订单数
};

/******************************************************一档行情******************************************************/
// 一档单腿行情
struct NanoZceL1MdType
{
    uint32_t  contract_no;          // 合约编码
    char      contract_name[20];    // 合约名称
    uint32_t  decimal;              // 价格精度
    int32_t   last_price;           // 最新价			（实际价格需要除以精度decimal, 无效数值是0x7FFFFFFF）
    int32_t   bid_price;            // 买价			（实际价格需要除以精度decimal, 无效数值是0x7FFFFFFF）
    int32_t   ask_price;            // 卖价			（实际价格需要除以精度decimal, 无效数值是0x7FFFFFFF）
    uint32_t  bid_qty;              // 买量
    uint32_t  ask_qty;              // 卖量
    uint32_t  match_qty;            // 成交量
    uint32_t  open_interest;        // 持仓量
    int32_t   derive_bid_price;     // 组合买入价		（实际价格需要除以精度decimal, 无效数值是0x7FFFFFFF）
    int32_t   derive_ask_price;     // 组合卖出价		（实际价格需要除以精度decimal, 无效数值是0x7FFFFFFF）
    uint32_t  derive_bid_qty;       // 组合买入数量
    uint32_t  derive_ask_qty;       // 组合卖出数量
    int32_t   avg_price;            // 平均价			（实际价格需要除以精度decimal, 无效数值是0x7FFFFFFF）
    uint32_t  update_time;          // 更新时间秒（Linux epoch时间戳格式）
    uint32_t  update_micro_sec;     // 更新时间微秒（交易所行情毫秒时间精确到微妙，如：250000、500000、750000）
    int64_t   turn_over;            // 总成交金额		（实际价格需要除以精度decimal,无效数值是0x7FFFFFFFFFFFFFFF）
    int32_t   limit_up_price;       // 当前未开放为0  涨停价（实际价格需要除以精度decimal, 无效数值是0x7FFFFFFF）
    int32_t   limit_down_price;     // 当前未开放为0  跌停价（实际价格需要除以精度decimal, 无效数值是0x7FFFFFFF）
};

// 一档组合行情
struct NanoZceL1ArbMdType
{
	uint32_t  contract_no;		    // 合约编码
	char	  contract_name[20];    // 合约名称
	uint32_t  decimal;		        // 价格精度
	int32_t	  bid_price;		    // 买价          （实际价格需要除以精度decimal, 无效数值是0x7FFFFFFF）
	int32_t	  ask_price;		    // 卖价          （实际价格需要除以精度decimal, 无效数值是0x7FFFFFFF）
	uint32_t  bid_qty; 		        // 买量
	uint32_t  ask_qty; 		        // 卖量
	uint32_t  total_bid_qty;        // 总买量
	uint32_t  total_ask_qty;        // 总卖量
	uint32_t  update_time;          // 更新时间秒（Linux epoch时间戳格式）
    uint32_t  update_micro_sec;     // 更新时间微秒（交易所行情毫秒时间精确到微妙，如：250000、500000、750000）
};
#pragma pack()
