#include <cstdlib>
#include <sched.h>
#include <math.h>
#include <pthread.h>
#include <sys/shm.h>
#include <unistd.h>
#include <pwd.h>
#include <signal.h>
#include <sys/param.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <arpa/inet.h>
#include <string.h>
#include <cerrno>
#include <time.h>
#include <thread>
#include <fstream>
#include <iostream>

#include "NanoZceMdApi.h"
#include "NanoZceMdStruct.h"


//回调接口继承
class CNanoZceMdSpiImpl:public INanoZceMdSpi
{
public:
	CNanoZceMdSpiImpl();
	virtual ~CNanoZceMdSpiImpl();
	int32_t Init(int32_t instanceIndex);
    virtual void OnNanoZceL2Md(const NanoZceL2MdType& refSNanoZceMd) override;//单腿合约数据
    virtual void OnNanoZceL2ArbMd(const NanoZceL2ArbMdType& refSNanoZceMd) override; //组合合约数据
	virtual void OnNanoZceL1Md(const NanoZceL1MdType& refSNanoZceMd)   override;
	virtual void OnNanoZceL1ArbMd(const NanoZceL1ArbMdType& refSNanoZceMd) override;


private:
	FILE *m_L5SglFile;
	FILE *m_L5CmbFile;
	FILE *m_L1SglFile;
	FILE *m_L1CmbFile;

    uint32_t m_L5SglCnt;
    uint32_t m_L5CmbCnt;
    uint32_t m_L1SglCnt;
    uint32_t m_L1CmbCnt;

	uint32_t m_uiChanIndex;
};

CNanoZceMdSpiImpl::CNanoZceMdSpiImpl() :
    m_L5SglFile(NULL),
    m_L5CmbFile(NULL),
    m_L1SglFile(NULL),
	m_L1CmbFile(NULL),
    m_L5SglCnt(0),
    m_L5CmbCnt(0),
    m_L1SglCnt(0),
    m_L1CmbCnt(0),
    m_uiChanIndex(0)
{
}

CNanoZceMdSpiImpl::~CNanoZceMdSpiImpl()
{
	if (0 != m_L5SglFile)
		fclose(m_L5SglFile);

	if (0 != m_L5CmbFile)
		fclose(m_L5CmbFile);

	if (0 != m_L1SglFile)
		fclose(m_L1SglFile);

	if (0 != m_L1CmbFile)
		fclose(m_L1CmbFile);

	printf("Dma channel:%d: L5Sgl count:%u, L5Cmb count:%u, L1Sgl count:%u, L1Sgl count:%u \n",
		    m_uiChanIndex, m_L5SglCnt, m_L5CmbCnt, m_L1SglCnt, m_L1CmbCnt);
}

int32_t CNanoZceMdSpiImpl::Init(int32_t instanceIndex)
{
	m_uiChanIndex = instanceIndex;

    char file_name[256] = {};
	sprintf(file_name, "Fpga_L5Sgl_channel%d.log", instanceIndex);

	if ((m_L5SglFile = fopen(file_name, "wt+")) == NULL)
	{
		printf("Cannot open file %s msg:%s \n", file_name, strerror(errno));
		return -1;
	}

	sprintf(file_name, "Fpga_L5Cmb_channel%d.log", instanceIndex);
	if ((m_L5CmbFile = fopen(file_name, "wt+")) == NULL)
	{
		printf("Cannot open file %s msg:%s \n", file_name, strerror(errno));
		return -1;
	}

	sprintf(file_name, "Fpga_L1Sgl_channel%d.log", instanceIndex);
	if ((m_L1SglFile = fopen(file_name, "wt+")) == NULL)
	{
		printf("Cannot open file %s msg:%s \n", file_name, strerror(errno));
		return -1;
	}

	sprintf(file_name, "Fpga_L1Cmb_channel%d.log", instanceIndex);
	if ((m_L1CmbFile = fopen(file_name, "wt+")) == NULL)
	{
		printf("Cannot open file %s msg:%s \n", file_name, strerror(errno));
		return -1;
	}

	return 0;
}

void CNanoZceMdSpiImpl::OnNanoZceL2Md(const NanoZceL2MdType& refSNanoZceMd)
{
	const NanoZceL2MdType	*pdata = &refSNanoZceMd;
	m_L5SglCnt++;
	fprintf(m_L5SglFile,"%u,"
						"%s,"
						"%u,"
						"%d,"
						"%u,"
						"%u,",
						pdata->contract_no,
						pdata->contract_name,
						pdata->decimal,
						pdata->last_price,
						pdata->match_qty,
						pdata->open_interest);

		fprintf(m_L5SglFile,"%d,"
							"%d,"
							"%u,"
							"%u,"
							"%d,"
							"%u,"
							"%u,"
							"%ld,",
							pdata->derive_bid_price,
							pdata->derive_ask_price,
							pdata->derive_bid_qty,
							pdata->derive_ask_qty,
							pdata->avg_price,
							pdata->update_time,
							pdata->update_micro_sec,
							pdata->turn_over
		);

		fprintf(m_L5SglFile,"%d,"
							"%d,"
							"%u,"
							"%d,"
							"%u,"
							"%d,"
							"%u,",
							pdata->limit_up_price,
							pdata->limit_down_price,
							pdata->total_bid_qty,
							pdata->bid_avg_price,
							pdata->total_ask_qty,
							pdata->ask_avg_price,
							pdata->deep_decimal);

		fprintf(m_L5SglFile,"%d,"
							"%u,"
							"%u,"
							"%d,"
							"%u,"
							"%u,",
							pdata->bid_price_1,
							pdata->bid_qty_1,
							pdata->bid_order_1,
							pdata->ask_price_1,
							pdata->ask_qty_1,
							pdata->ask_order_1);

	fprintf(m_L5SglFile,"%d,"
						"%u,"
						"%u,"
						"%d,"
						"%u,"
						"%u,"
						"%d,"
						"%u,"
						"%u,"
						"%d,"
						"%u,"
						"%u,"
						"%d,"
						"%u,"
						"%u,"
						"%d,"
						"%u,"
						"%u,"
						"%d,"
						"%u,"
						"%u,"
						"%d,"
						"%u,"
						"%u\n",
						pdata->bid_price_2,
						pdata->bid_qty_2,
						pdata->bid_order_2,
						pdata->ask_price_2,
						pdata->ask_qty_2,
						pdata->ask_order_2,
						pdata->bid_price_3,
						pdata->bid_qty_3,
						pdata->bid_order_3,
						pdata->ask_price_3,
						pdata->ask_qty_3,
						pdata->ask_order_3,
						pdata->bid_price_4,
						pdata->bid_qty_4,
						pdata->bid_order_4,
						pdata->ask_price_4,
						pdata->ask_qty_4,
						pdata->ask_order_4,
						pdata->bid_price_5,
						pdata->bid_qty_5,
						pdata->bid_order_5,
						pdata->ask_price_5,
						pdata->ask_qty_5,
						pdata->ask_order_5);

}

void CNanoZceMdSpiImpl::OnNanoZceL2ArbMd(const NanoZceL2ArbMdType& refSNanoZceMd)
{
	const NanoZceL2ArbMdType *pdata = &refSNanoZceMd;
	 m_L5CmbCnt++;

     fprintf(m_L5CmbFile,"%u,"
						 "%s,"
                     	 "%u,"
                     	 "%u,"
                     	 "%u,"
                     	 "%u,",
	                      pdata->contract_no,
	                      pdata->contract_name,
	                      pdata->total_bid_qty,
	                      pdata->total_ask_qty,
	                      pdata->update_time,
	                      pdata->update_micro_sec);

	fprintf(m_L5CmbFile, "%u,"
						 "%d,"
						 "%u,"
						 "%u,"
						 "%d,"
						 "%u,"
						 "%u,",
						  pdata->deep_decimal,
						  pdata->bid_price_1,
						  pdata->bid_qty_1,
						  pdata->bid_order_1,
						  pdata->ask_price_1,
						  pdata->ask_qty_1,
						  pdata->ask_order_1);

	  fprintf(m_L5CmbFile,"%d,"
						  "%u,"
						  "%u,"
						  "%d,"
						  "%u,"
						  "%u,"
						  "%d,"
						  "%u,"
						  "%u,"
						  "%d,"
						  "%u,"
						  "%u,"
						  "%d,"
						  "%u,"
						  "%u,"
						  "%d,"
						  "%u,"
						  "%u,"
						  "%d,"
						  "%u,"
						  "%u,"
						  "%d,"
						  "%u,"
						  "%u\n",
						  pdata->bid_price_2,
						  pdata->bid_qty_2,
						  pdata->bid_order_2,
						  pdata->ask_price_2,
						  pdata->ask_qty_2,
						  pdata->ask_order_2,
						  pdata->bid_price_3,
						  pdata->bid_qty_3,
						  pdata->bid_order_3,
						  pdata->ask_price_3,
						  pdata->ask_qty_3,
						  pdata->ask_order_3,
						  pdata->bid_price_4,
						  pdata->bid_qty_4,
						  pdata->bid_order_4,
						  pdata->ask_price_4,
						  pdata->ask_qty_4,
						  pdata->ask_order_4,
						  pdata->bid_price_5,
						  pdata->bid_qty_5,
						  pdata->bid_order_5,
						  pdata->ask_price_5,
						  pdata->ask_qty_5,
						  pdata->ask_order_5);


    return;
}


void CNanoZceMdSpiImpl::OnNanoZceL1Md(const NanoZceL1MdType& refSNanoZceMd)
{
	const NanoZceL1MdType *pdata = &refSNanoZceMd;
	m_L1SglCnt++;

	fprintf(m_L1SglFile, "%u,"
						 "%s,"
						 "%u,"
						 "%d,"
						 "%d,"
						 "%d,"
						 "%u,"
						 "%u,",
						  pdata->contract_no,
						  pdata->contract_name,
						  pdata->decimal,
						  pdata->last_price,
						  pdata->bid_price,
						  pdata->ask_price,
						  pdata->bid_qty,
						  pdata->ask_qty);

	fprintf(m_L1SglFile, "%u,"
						 "%u,"
						 "%d,"
						 "%d,"
						 "%u,"
						 "%u,"
						 "%d,",
						  pdata->match_qty,
						  pdata->open_interest,
						  pdata->derive_bid_price,
						  pdata->derive_ask_price,
						  pdata->derive_bid_qty,
						  pdata->derive_ask_qty,
						  pdata->avg_price);

	fprintf(m_L1SglFile, "%u,"
						 "%u,"
						 "%ld,"
						 "%d,"
						 "%d\n",
						 pdata->update_time,
						 pdata->update_micro_sec,
						 pdata->turn_over,
						 pdata->limit_up_price,
						 pdata->limit_down_price);
}

void CNanoZceMdSpiImpl::OnNanoZceL1ArbMd(const NanoZceL1ArbMdType& refSNanoZceMd)
{
	const NanoZceL1ArbMdType *pdata = &refSNanoZceMd;
	m_L1CmbCnt++;

	fprintf(m_L1CmbFile, "%u,"
						 "%s,"
						 "%u,"
						 "%d,"
						 "%d,"
						 "%u,"
						 "%u,"
						 "%u,"
						 "%u,"
						 "%u,"
						 "%u\n",
						 pdata->contract_no,
						 pdata->contract_name,
						 pdata->decimal,
						 pdata->bid_price,
						 pdata->ask_price,
						 pdata->bid_qty,
						 pdata->ask_qty,
						 pdata->total_bid_qty,
						 pdata->total_ask_qty,
						 pdata->update_time,
						 pdata->update_micro_sec);
}

int32_t NanoZceFunc(int32_t instanceIndex)
{
    printf("NanoZceFunc: ......start\n");

	char szBuf[32] = {};

    CNanoZceMdSpiImpl *pmdSpi = new CNanoZceMdSpiImpl();
	if (NULL == pmdSpi)
	{
		printf("Init fail \n");
		return -1;
	}

	if (0 != pmdSpi->Init(instanceIndex))
	{
		printf("mdspi init fail. \n");
		return -1;
	}

    INanoZceMdApi& refNanoMdApi = INanoZceMdApi::CreateNanoZceMdApi();

	sprintf(szBuf, "config_%d.ini", instanceIndex);

//阻塞示例
#if 1
    {
        printf("Blocking mode:\n");
        refNanoMdApi.NanoRecvStart(*pmdSpi, szBuf);

		//when ctrl+c, is_running=false, NanoRecvStart will stops and return.
    }
#endif

    //非阻塞示例
#if 0
    {
        printf("Non block mode:\n");

        if(0 != refNanoMdApi.NanoStart(*pmdSpi, szBuf))
        {
            printf("Nano init failed\n");
            return -1;
        }

        int32_t nRet = -1;

		while (-1 != (nRet = refNanoMdApi.NanoRecv()))
        {
            if (0 == nRet)
            {
                //printf("NanoZceFunc: none dma data\n");
            }
            else if (1 == nRet)
            {
                //printf("NanoZceFunc: have dma data !!!! \n");
            }
        }
    }
#endif

	    INanoZceMdApi::DestroyNanoZceMdApi(refNanoMdApi);
		delete pmdSpi;

    return 0;
}

int main(int argc, char** argv)
{
    if (argc < 2)
    {
        printf("Usage: %s ChannelCount\n", argv[0]);
        return -1;
    }

    int32_t InstanceCount = atoi(argv[1]);
    if ((InstanceCount < 1) || (InstanceCount > 16))
    {
        //Count ∈ [1~16]
        printf("Usage: %s Count ∈ [1~16]\n", argv[0]);
        return -1;
    }

    std::thread threadArray[16];
    for (int32_t index = 0; index < InstanceCount; ++index)
    {
        threadArray[index] = std::thread(NanoZceFunc, index);
    }

    for (int32_t index = 0; index < InstanceCount; ++index)
    {
        threadArray[index].join();
    }

    return 0;
}


