#include <stdio.h>
#include <stdint.h>
#include <string.h>
#include <exanic/exanic.h>
#include <exanic/fifo_rx.h>
#include <exanic/util.h>

#include "gfex.h"
#include <signal.h>
#include <fstream>

class CWriteLog
{
public:
    CWriteLog()
    {
        _CreateShowFile();
    }

    void Flush()
    {
        if (m_fileLevel2Stream.is_open())
        {
            m_fileLevel2Stream.flush();
            m_fileLevel2Stream.close();
        }
    }

    void OnNanoGfexL2Md(const NanoGfexL2MdType& refNanoGfexL2Md)
    {
        m_fileLevel2Stream << "OnNanoGfexL2Md" << ",";
        m_fileLevel2Stream << "contract_name=" <<          refNanoGfexL2Md.contract_name      << ",";
        m_fileLevel2Stream << "last_price=" <<           refNanoGfexL2Md.last_price           << ",";
        m_fileLevel2Stream << "last_match_qty=" <<       refNanoGfexL2Md.last_match_qty       << ",";
        m_fileLevel2Stream << "match_total_qty=" <<      refNanoGfexL2Md.match_total_qty      << ",";
        m_fileLevel2Stream << "turn_over=" <<            refNanoGfexL2Md.turn_over            << ",";
        m_fileLevel2Stream << "open_interest=" <<        refNanoGfexL2Md.open_interest        << ",";
        m_fileLevel2Stream << "open_interest_change=" << refNanoGfexL2Md.open_interest_change << ",";
        m_fileLevel2Stream << "gen_time=" <<             refNanoGfexL2Md.gen_time             << ",";
        m_fileLevel2Stream << "bid1_px=" <<              refNanoGfexL2Md.bid1_px              << ",";
        m_fileLevel2Stream << "bid1_vol=" <<             refNanoGfexL2Md.bid1_vol              << ",";
        m_fileLevel2Stream << "bid2_px=" <<              refNanoGfexL2Md.bid2_px              << ",";
        m_fileLevel2Stream << "bid2_vol=" <<             refNanoGfexL2Md.bid2_vol              << ",";
        m_fileLevel2Stream << "bid3_px=" <<              refNanoGfexL2Md.bid3_px              << ",";
        m_fileLevel2Stream << "bid3_vol=" <<             refNanoGfexL2Md.bid3_vol             << ",";
        m_fileLevel2Stream << "bid4_px=" <<              refNanoGfexL2Md.bid4_px             << ",";
        m_fileLevel2Stream << "bid4_vol=" <<             refNanoGfexL2Md.bid4_vol             << ",";
        m_fileLevel2Stream << "bid5_px=" <<              refNanoGfexL2Md.bid5_px             << ",";
        m_fileLevel2Stream << "bid5_vol=" <<             refNanoGfexL2Md.bid5_vol             << ",";
        m_fileLevel2Stream << "ask1_px=" <<              refNanoGfexL2Md.ask1_px              << ",";
        m_fileLevel2Stream << "ask1_vol=" <<             refNanoGfexL2Md.ask1_vol              << ",";
        m_fileLevel2Stream << "ask2_px=" <<              refNanoGfexL2Md.ask2_px              << ",";
        m_fileLevel2Stream << "ask2_vol=" <<             refNanoGfexL2Md.ask2_vol              << ",";
        m_fileLevel2Stream << "ask3_px=" <<              refNanoGfexL2Md.ask3_px              << ",";
        m_fileLevel2Stream << "ask3_vol=" <<             refNanoGfexL2Md.ask3_vol             << ",";
        m_fileLevel2Stream << "ask4_px=" <<              refNanoGfexL2Md.ask4_px             << ",";
        m_fileLevel2Stream << "ask4_vol=" <<             refNanoGfexL2Md.ask4_vol             << ",";
        m_fileLevel2Stream << "ask5_px=" <<              refNanoGfexL2Md.ask5_px             << ",";
        m_fileLevel2Stream << "ask5_vol=" <<             refNanoGfexL2Md.ask5_vol             << ",";
        m_fileLevel2Stream << "buy_imply_qty_1=" <<      refNanoGfexL2Md.buy_imply_qty_1      << ",";
        m_fileLevel2Stream << "buy_imply_qty_2=" <<      refNanoGfexL2Md.buy_imply_qty_2      << ",";
        m_fileLevel2Stream << "buy_imply_qty_3=" <<      refNanoGfexL2Md.buy_imply_qty_3      << ",";
        m_fileLevel2Stream << "buy_imply_qty_4=" <<      refNanoGfexL2Md.buy_imply_qty_4      << ",";
        m_fileLevel2Stream << "buy_imply_qty_5=" <<      refNanoGfexL2Md.buy_imply_qty_5      << ",";
        m_fileLevel2Stream << "sell_imply_qty_1=" <<     refNanoGfexL2Md.sell_imply_qty_1     << ",";
        m_fileLevel2Stream << "sell_imply_qty_2=" <<     refNanoGfexL2Md.sell_imply_qty_2     << ",";
        m_fileLevel2Stream << "sell_imply_qty_3=" <<     refNanoGfexL2Md.sell_imply_qty_3     << ",";
        m_fileLevel2Stream << "sell_imply_qty_4=" <<     refNanoGfexL2Md.sell_imply_qty_4     << ",";
        m_fileLevel2Stream << "sell_imply_qty_5=" <<     refNanoGfexL2Md.sell_imply_qty_5     << std::endl;
    }

private:
    int32_t _CreateShowFile()
    {
        char file_name[256] = {};
        time_t time_now = {};
        time(&time_now);
        struct tm *tm_now = localtime(&time_now);

        //五档落地文件
        {
            sprintf(file_name, "nano_exanic_level2_%04d%02d%02d_%02d%02d%02d.csv", tm_now->tm_year + 1900, tm_now->tm_mon + 1, tm_now->tm_mday, tm_now->tm_hour, tm_now->tm_min, tm_now->tm_sec);
            m_fileLevel2Stream.open(file_name);
            m_fileLevel2Stream.precision(6);
            m_fileLevel2Stream.setf(std::ios::uppercase|std::ios::scientific);
        }

        return 0;
    }

private:
    std::ofstream           m_fileLevel2Stream;       //五档落地文件流对象
};

CWriteLog mdLog = {};

int keep_running = 1;
void sig_handler(int signal)
{
    keep_running = 0;
    mdLog.Flush();
    printf("received Ctrl + C signal.\n");
}

int main(int argc, char*argv[])
{
    if (argc != 2)
    {
        fprintf(stderr, "Usage: %s exanic[0-N]\n", argv[0]);
        return -1;
    }

    signal(SIGINT, sig_handler);

    exanic_t *nic = exanic_acquire_handle(argv[1]);
    if (!nic)
    {
        fprintf(stderr, "exanic_acquire_handle: %s\n", exanic_get_last_error());
        return 1;
    }

    exanic_rx_t *rx = exanic_acquire_rx_buffer(nic, 1, 0);
    if(!rx)
    {
        fprintf(stderr, "exanic_acquire_rx_buffer: %s\n", exanic_get_last_error());
        return 1;
    }

    char packet[2048];
    memset(packet, 0, sizeof(packet));

    while(keep_running)
    {
        ssize_t sz = exanic_receive_frame(rx, packet, sizeof(packet), NULL);
        if (sz == sizeof(NanoGfexL2MdType) || sz == sizeof(NanoGfexL2MdType) + 4)
        {
            NanoGfexL2MdType *gfexMd = (NanoGfexL2MdType *)packet;

            mdLog.OnNanoGfexL2Md(*gfexMd);
        }
    }

    return 0;
}
