#pragma once

#include <cstdint>
#pragma pack(1)

/******************************************************五档行情******************************************************/
struct NanoGfexL2MdType
{
    uint32_t        flag;				        // BEST: 0x54534542, ARBI: 0x49425241
    char            contract_name[20];          //合约代码
    double          last_price;                 //最新成交价
    uint32_t        last_match_qty;             //最新成交量
    uint32_t        match_total_qty;            //总成交量
    double          turn_over;                  //总成交额
    uint32_t        open_interest;              //持仓量
    int32_t         open_interest_change;       //持仓量变化量，同一合约号先后两个持仓量的变化
    char            gen_time[16];               //交易时间
    double          bid1_px;                    //买一价
    uint32_t        bid1_vol;                   //买一量
    double          bid2_px;                    //买二价
    uint32_t        bid2_vol;                   //买二量
    double          bid3_px;                    //买三价
    uint32_t        bid3_vol;                   //买三量
    double          bid4_px;                    //买四价
    uint32_t        bid4_vol;                   //买四量
    double          bid5_px;                    //买五价
    uint32_t        bid5_vol;                   //买五量
    double          ask1_px;                    //卖一价
    uint32_t        ask1_vol;                   //卖一量        
    double          ask2_px;                    //卖二价
    uint32_t        ask2_vol;                   //卖二量
    double          ask3_px;                    //卖三价
    uint32_t        ask3_vol;                   //卖三量
    double          ask4_px;                    //卖四价
    uint32_t        ask4_vol;                   //卖四量
    double          ask5_px;                    //卖五价
    uint32_t        ask5_vol;                   //卖五量
    int32_t         buy_imply_qty_1;            //档1申买推导量
    int32_t         buy_imply_qty_2;            //档2申买推导量
    int32_t         buy_imply_qty_3;            //档3申买推导量
    int32_t         buy_imply_qty_4;            //档4申买推导量
    int32_t         buy_imply_qty_5;            //档5申买推导量
    int32_t         sell_imply_qty_1;           //档1申卖推导量
    int32_t         sell_imply_qty_2;           //档2申卖推导量
    int32_t         sell_imply_qty_3;           //档3申卖推导量
    int32_t         sell_imply_qty_4;           //档4申卖推导量
    int32_t         sell_imply_qty_5;           //档5申卖推导量
};
#pragma pack()