#!/bin/bash

if [[ -z "$1" ]];then
    echo "Please specify target install exchange." 
	echo "eg: ${0} shfe/dce/gfex/czce/cffex" && exit 1
fi

if [[ -z $(lspci | grep -i enyx) ]];then
	echo "The U50 board was not loaded properly. Please check if the board is properly inserted or try rebooting and reloading" && exit 1
fi

CurrDir=$(pwd)
if [[ ! -d "${CurrDir}/fw" ]] || [[ ! -d "${CurrDir}/utils" ]] || [[ ! -d "${CurrDir}/sample-code" ]];then
	echo "It has already been installed. Please clear the scheduled tasks before reinstalling and unzip the installation package to reinstall and deploy" && exit 1
fi

NanoDir="/root/nano_u50_${1}"
if [[ -d "${NanoDir}" ]];then
	mv ${NanoDir} ${NanoDir}_$(date +'%Y%m%d_%H%M%S')
fi
mkdir ${NanoDir}
mv sample-code utils Readme.txt ${NanoDir}

# gen show_reg shell script，and install crontab
cd ${NanoDir}/utils/reg
cat <<EOF > show_reg.sh
#!/bin/bash
(date +'%Y-%m-%d %H:%M:%S' && ${NanoDir}/utils/reg/nano_state xilinx0 cat) >> ${NanoDir}/utils/reg/reg_\$(date +'%Y-%m-%d').log
EOF
cat <<EOF > fpga_reset.sh
#!/bin/bash
enyx-cores-example-hw-top-reset 0
enyx-hfp-bus-reset 0
EOF
cat <<EOF > cron
0 6 * * 1-5 ${NanoDir}/utils/reg/fpga_reset.sh
20-22 3,8,10,12,15,20 * * 1-6 ${NanoDir}/utils/reg/show_reg.sh
0-10,50-59 8,9,20,21 * * 1-6 ${NanoDir}/utils/reg/show_reg.sh
EOF

serverName="crond"
cronDir="/var/spool/cron/root"
source /etc/os-release
if [[ "ubuntu" == ${ID} ]];then
	serverName="cron"
	cronDir="/var/spool/cron/crontabs/root"
	lsb_release -a
fi

if [[ -f ${cronDir} ]];then
	cat cron >> ${cronDir}
else
	crontab cron
fi
chmod +x ${NanoDir}/utils/reg/*

chown root.root ${NanoDir} -R
systemctl enable ${serverName}
systemctl start ${serverName}
echo "${serverName} service is $(systemctl is-enabled ${serverName})"

cd ${NanoDir}/sample-code/demo
make clean && make
./run.sh 2&> test.log &
sleep 10
skill api

echo "please tell luis the following info."
echo $(grep DNA test.log | head -n 1)
echo $(ip a | grep inet | awk '{print $2}')

#clear fw
cd ${CurrDir}
rm -rf fw
