#include "NanoDceMdApi.h"
#include <cstdio>
#include <cstdlib>
#include <time.h>
#include <thread>
#include <fstream>
#include <iostream>

class CNanoDceMdSpiImpl : public CNanoDceMdSpi
{
public:
    CNanoDceMdSpiImpl(int32_t instanceIndex);
    ~CNanoDceMdSpiImpl();
public:
    //一档行情回调接口
    virtual void OnNanoDceL1Md(const NanoDceL1MdType& refNanoDceL1Md);

    //五档行情回调接口
    virtual void OnNanoDceL2ContractBestPriceMd(const NanoDceL2ContractBestPriceMdType& refNanoDceL2ContractBestPriceMd);
    virtual void OnNanoDceL2ArbBestPriceMd(const NanoDceL2ArbBestPriceMdType& refNanoDceL2ArbBestPriceMd);
    virtual void OnNanoDceL2SegQuotaMd(const NanoDceL2SegQuotaMdType& refNanoDceL2SegQuotaMd);
    virtual void OnNanoDceL2OrderStatisticsMd(const NanoDceL2OrderStatisticsMdType& refNanoDceL2OrderStatisticsMd);
    virtual void OnNanoDceL2DeepOrderVolumeMd(const NanoDceL2DeepOrderVolumeMdType& refDeepOrderVolumeMd);
    virtual void OnNanoDceL2DeepQuoteMd(const NanoDceL2DeepQuoteMdType& refNanoDceL2DeepMd);

    //事件通知
    virtual void OnEvent(const NanoEventType& refEventType);
public:
    void ShowInstStaticInfo(const NanoDceInstStaticInfo& refInstStaticInfo);

private:
    int32_t _CreateShowFile();

private:
    std::ofstream           m_fileLevel1Stream;       //一档落地文件流对象
    std::ofstream           m_fileLevel2Stream;       //五档落地文件流对象
    int32_t                 m_instanceIndex = 0;
};


void NanoDceFunc(int32_t instanceIndex)
{
    printf("NanoDceFunc: %d......start\n", instanceIndex);
    CNanoDceMdSpiImpl mdSpi(instanceIndex);
    CNanoDceMdApi& refNanoDceMdApi = CNanoDceMdApi::CreateNanoDceMdApi();

    char szBuf[32] = {};
    sprintf(szBuf, "config_%d.ini", instanceIndex);

    //阻塞示例
    #if 0
    {
        printf("NanoDceFunc: %d 阻塞模式\n", instanceIndex);
        refNanoDceMdApi.NanoRecvStart(mdSpi, szBuf);
    }
    #endif

    //非阻塞示例
    #if 1
    {
        printf("NanoDceFunc: %d 非阻塞模式\n", instanceIndex);
        if (0 != refNanoDceMdApi.NanoStart(mdSpi, szBuf))
        {
            printf("NanoDceFunc: NanoStart failed\n");
            return;
        }

        //获取合约静态信息
        NanoDceInstStaticInfo refInstStaticInfo = {};
        if (0 == refNanoDceMdApi.GetInstStaticInfo("jd2404", refInstStaticInfo))
        {
            mdSpi.ShowInstStaticInfo(refInstStaticInfo);
        }

        if (0 == refNanoDceMdApi.GetInstStaticInfo("m2405-C-3150", refInstStaticInfo))
        {
            mdSpi.ShowInstStaticInfo(refInstStaticInfo);
        }

        if (0 == refNanoDceMdApi.GetInstStaticInfo("SP eg2306&eg2307", refInstStaticInfo))
        {
            mdSpi.ShowInstStaticInfo(refInstStaticInfo);
        }

        if (0 == refNanoDceMdApi.GetInstStaticInfo("SPC v2309&pp2309", refInstStaticInfo))
        {
            mdSpi.ShowInstStaticInfo(refInstStaticInfo);
        }

        if (0 == refNanoDceMdApi.GetInstStaticInfo("ag2405", refInstStaticInfo))
        {
            mdSpi.ShowInstStaticInfo(refInstStaticInfo);
        }

        if (0 == refNanoDceMdApi.GetInstStaticInfo(nullptr, refInstStaticInfo))
        {
            mdSpi.ShowInstStaticInfo(refInstStaticInfo);
        }

        int32_t nRet = -1;
        while (-1 != (nRet = refNanoDceMdApi.NanoRecv()))
        {
            if (0 == nRet)
            {
                //printf("NanoDceFunc: none dma data\n");
            }
            else if (1 == nRet)
            {
                //printf("NanoDceFunc: have dma data\n");
            }
        }
    }
    #endif

	CNanoDceMdApi::DestroyNanoDceMdApi(refNanoDceMdApi);
    printf("NanoDceFunc: %d......end\n", instanceIndex);
}

int32_t main(int32_t argc, char** argv)
{
    if (argc < 2)
    {
        printf("Usage: %s Count\n", argv[0]);
        return -1;
    }

    int32_t InstanceCount = atoi(argv[1]);
    if ((InstanceCount < 1) || (InstanceCount > 16))
    {
        //Count ∈ [1~16]
        printf("Usage: %s Count ∈ [1~16]\n", argv[0]);
        return -1;
    }

    std::thread threadArray[16];
    for (int32_t index = 0; index < InstanceCount; ++index)
    {
        threadArray[index] = std::thread(NanoDceFunc, index);
    }
    
    for (int32_t index = 0; index < InstanceCount; ++index)
    {
        threadArray[index].join();
    }

    return 0;
}


CNanoDceMdSpiImpl::CNanoDceMdSpiImpl(int32_t instanceIndex)
    : m_instanceIndex(instanceIndex)
{
    _CreateShowFile();
}

CNanoDceMdSpiImpl::~CNanoDceMdSpiImpl()
{
    if (m_fileLevel1Stream.is_open())
    {
        m_fileLevel1Stream.flush();
        m_fileLevel1Stream.close();
    }

    if (m_fileLevel2Stream.is_open())
    {
        m_fileLevel2Stream.flush();
        m_fileLevel2Stream.close();
    }
}

int32_t CNanoDceMdSpiImpl::_CreateShowFile()
{
    char file_name[256] = {};
    time_t time_now = {};
    time(&time_now);
    struct tm *tm_now = localtime(&time_now);

    //一档落地文件
    {
        sprintf(file_name, "nano_u50_level1_channel%d_%04d%02d%02d_%02d%02d%02d.csv", m_instanceIndex, tm_now->tm_year + 1900, tm_now->tm_mon + 1, tm_now->tm_mday, tm_now->tm_hour, tm_now->tm_min, tm_now->tm_sec);
        m_fileLevel1Stream.open(file_name);
        m_fileLevel1Stream.precision(6);
        m_fileLevel1Stream.setf(std::ios::uppercase|std::ios::scientific);
    }

    //五档落地文件
    {
        sprintf(file_name, "nano_u50_level2_channel%d_%04d%02d%02d_%02d%02d%02d.csv", m_instanceIndex, tm_now->tm_year + 1900, tm_now->tm_mon + 1, tm_now->tm_mday, tm_now->tm_hour, tm_now->tm_min, tm_now->tm_sec);
        m_fileLevel2Stream.open(file_name);
        m_fileLevel2Stream.precision(6);
        m_fileLevel2Stream.setf(std::ios::uppercase|std::ios::scientific);
    }

    return 0;
}

void CNanoDceMdSpiImpl::ShowInstStaticInfo(const NanoDceInstStaticInfo& refInstStaticInfo)
{
    std::cout << "ShowInstStaticInfo" << ",";
    std::cout << "contract_no=" << 			    refInstStaticInfo.contract_no << ",";
    std::cout << "contract_name=" << 		    refInstStaticInfo.contract_name << ",";
    std::cout << "trade_date=" << 		        refInstStaticInfo.trade_date << ",";
    std::cout << "contract_type=" << 	        refInstStaticInfo.contract_type << ",";
    std::cout << "init_open_interst=" << 		refInstStaticInfo.init_open_interst << ",";
    std::cout << "limit_up_px=" << 			    refInstStaticInfo.limit_up_px << ",";
    std::cout << "limit_down_px=" << 			refInstStaticInfo.limit_down_px << ",";
    std::cout << "last_settlement_price=" << 	refInstStaticInfo.last_settlement_price << ",";
    std::cout << "last_closing_price=" << 		refInstStaticInfo.last_closing_price << ",";
    std::cout << "codec_price=" << 			    refInstStaticInfo.codec_price << ",";
    std::cout << "tick=" << 	                refInstStaticInfo.tick << std::endl;
}

void CNanoDceMdSpiImpl::OnEvent(const NanoEventType& refEventType)
{
    std::cout << "OnEvent" << ",";
    std::cout << "event_type=" << 	            refEventType << std::endl;
}

void CNanoDceMdSpiImpl::OnNanoDceL1Md(const NanoDceL1MdType& refNanoDceL1Md)
{
    m_fileLevel1Stream << "OnNanoDceL1Md" << ",";
    m_fileLevel1Stream << "send_time=" << 			refNanoDceL1Md.send_time << ",";
    m_fileLevel1Stream << "contract_no=" << 		refNanoDceL1Md.contract_no << ",";
    m_fileLevel1Stream << "contract_seq=" << 		refNanoDceL1Md.contract_seq << ",";
    m_fileLevel1Stream << "contract_name=" << 	    refNanoDceL1Md.contract_name << ",";
    m_fileLevel1Stream << "last_price=" << 			refNanoDceL1Md.last_price << ",";
    m_fileLevel1Stream << "last_qty=" << 			refNanoDceL1Md.last_qty << ",";
    m_fileLevel1Stream << "total_qty=" << 			refNanoDceL1Md.total_qty << ",";
    m_fileLevel1Stream << "turn_over=" << 			refNanoDceL1Md.turn_over << ",";
    m_fileLevel1Stream << "open_interest=" << 		refNanoDceL1Md.open_interest << ",";
    m_fileLevel1Stream << "open_interest_change=" <<refNanoDceL1Md.open_interest_change << ",";
    m_fileLevel1Stream << "avg_price=" <<  			refNanoDceL1Md.avg_price << ",";
    m_fileLevel1Stream << "bid_price=" <<  			refNanoDceL1Md.bid_price << ",";
    m_fileLevel1Stream << "bid_qty=" << 			refNanoDceL1Md.bid_qty << ",";
    m_fileLevel1Stream << "bid_imply_qty=" << 		refNanoDceL1Md.bid_imply_qty << ",";
    m_fileLevel1Stream << "ask_price=" <<  			refNanoDceL1Md.ask_price << ",";
    m_fileLevel1Stream << "ask_qty=" << 			refNanoDceL1Md.ask_qty << ",";
    m_fileLevel1Stream << "ask_imply_qty=" << 		refNanoDceL1Md.ask_imply_qty << std::endl;
}


void CNanoDceMdSpiImpl::OnNanoDceL2ContractBestPriceMd(const NanoDceL2ContractBestPriceMdType& refNanoDceL2ContractBestPriceMd)
{
    m_fileLevel2Stream << "OnNanoDceL2ContractBestPriceMd" << ",";
    m_fileLevel2Stream << "contract_name=" <<         refNanoDceL2ContractBestPriceMd.contract_name << ",";
    m_fileLevel2Stream << "contract_no=" <<         refNanoDceL2ContractBestPriceMd.contract_no << ",";
    m_fileLevel2Stream << "trade_date=" <<          refNanoDceL2ContractBestPriceMd.trade_date << ",";
    m_fileLevel2Stream << "gen_time=" <<            refNanoDceL2ContractBestPriceMd.gen_time << ",";
    m_fileLevel2Stream << "last_price=" <<          refNanoDceL2ContractBestPriceMd.last_price << ",";
    m_fileLevel2Stream << "high_price=" <<          refNanoDceL2ContractBestPriceMd.high_price << ",";
    m_fileLevel2Stream << "low_price=" <<           refNanoDceL2ContractBestPriceMd.low_price << ",";
    m_fileLevel2Stream << "last_match_qty=" <<      refNanoDceL2ContractBestPriceMd.last_match_qty << ",";
    m_fileLevel2Stream << "match_tot_qty=" <<       refNanoDceL2ContractBestPriceMd.match_tot_qty << ",";
    m_fileLevel2Stream << "turnover=" <<            refNanoDceL2ContractBestPriceMd.turnover << ",";
    m_fileLevel2Stream << "open_interest=" <<       refNanoDceL2ContractBestPriceMd.open_interest << ",";
    m_fileLevel2Stream << "interest_chg=" <<        refNanoDceL2ContractBestPriceMd.interest_chg << ",";
    m_fileLevel2Stream << "rise_limit=" <<          refNanoDceL2ContractBestPriceMd.rise_limit << ",";
    m_fileLevel2Stream << "fall_limit=" <<          refNanoDceL2ContractBestPriceMd.fall_limit << ",";
    m_fileLevel2Stream << "bid_price=" <<           refNanoDceL2ContractBestPriceMd.bid_price << ",";
    m_fileLevel2Stream << "bid_qty=" <<             refNanoDceL2ContractBestPriceMd.bid_qty << ",";
    m_fileLevel2Stream << "bid_imply_qty=" <<       refNanoDceL2ContractBestPriceMd.bid_imply_qty << ",";
    m_fileLevel2Stream << "ask_price=" <<           refNanoDceL2ContractBestPriceMd.ask_price << ",";
    m_fileLevel2Stream << "ask_qty=" <<             refNanoDceL2ContractBestPriceMd.ask_qty << ",";
    m_fileLevel2Stream << "ask_imply_qty=" <<       refNanoDceL2ContractBestPriceMd.ask_imply_qty << ",";
    m_fileLevel2Stream << "avg_price=" <<           refNanoDceL2ContractBestPriceMd.avg_price << std::endl;
}

void CNanoDceMdSpiImpl::OnNanoDceL2ArbBestPriceMd(const NanoDceL2ArbBestPriceMdType& refNanoDceL2ArbBestPriceMd)
{
    m_fileLevel2Stream << "OnNanoDceL2ArbBestPriceMd" << ",";
    m_fileLevel2Stream << "contract_name=" <<         refNanoDceL2ArbBestPriceMd.contract_name << ",";
    m_fileLevel2Stream << "contract_no=" <<         refNanoDceL2ArbBestPriceMd.contract_no << ",";
    m_fileLevel2Stream << "trade_date=" <<          refNanoDceL2ArbBestPriceMd.trade_date << ",";
    m_fileLevel2Stream << "gen_time=" <<            refNanoDceL2ArbBestPriceMd.gen_time << ",";
    m_fileLevel2Stream << "last_price=" <<  	    refNanoDceL2ArbBestPriceMd.last_price << ",";
    m_fileLevel2Stream << "last_match_qty=" <<      refNanoDceL2ArbBestPriceMd.last_match_qty << ",";
    m_fileLevel2Stream << "rise_limit=" <<  	    refNanoDceL2ArbBestPriceMd.rise_limit << ",";
    m_fileLevel2Stream << "fall_limit=" <<  	    refNanoDceL2ArbBestPriceMd.fall_limit << ",";
    m_fileLevel2Stream << "bid_price=" << 		    refNanoDceL2ArbBestPriceMd.bid_price << ",";
    m_fileLevel2Stream << "bid_qty=" << 			refNanoDceL2ArbBestPriceMd.bid_qty << ",";
    m_fileLevel2Stream << "ask_price=" << 		    refNanoDceL2ArbBestPriceMd.ask_price << ",";
    m_fileLevel2Stream << "ask_qty=" << 			refNanoDceL2ArbBestPriceMd.ask_qty << std::endl;
}


void CNanoDceMdSpiImpl::OnNanoDceL2SegQuotaMd(const NanoDceL2SegQuotaMdType& refNanoDceL2SegQuotaMd)
{
    m_fileLevel2Stream << "OnNanoDceL2SegQuotaMd" << ",";
    m_fileLevel2Stream << "contract_name=" <<         refNanoDceL2SegQuotaMd.contract_name << ",";
    m_fileLevel2Stream << "contract_no=" <<         refNanoDceL2SegQuotaMd.contract_no << ",";
    m_fileLevel2Stream << "trade_date=" <<          refNanoDceL2SegQuotaMd.trade_date << ",";
    m_fileLevel2Stream << "gen_time=" <<            refNanoDceL2SegQuotaMd.gen_time << ",";
    m_fileLevel2Stream << "price_1=" <<             refNanoDceL2SegQuotaMd.price_1 << ",";
    m_fileLevel2Stream << "price_1bo_qty=" << 	    refNanoDceL2SegQuotaMd.price_1bo_qty << ",";
    m_fileLevel2Stream << "price_1be_qty=" << 	    refNanoDceL2SegQuotaMd.price_1be_qty << ",";
    m_fileLevel2Stream << "price_1so_qty=" << 	    refNanoDceL2SegQuotaMd.price_1so_qty << ",";
    m_fileLevel2Stream << "price_1se_qty=" << 	    refNanoDceL2SegQuotaMd.price_1se_qty << ",";
    m_fileLevel2Stream << "price_2=" <<  			refNanoDceL2SegQuotaMd.price_2 << ",";
    m_fileLevel2Stream << "price_2bo_qty=" << 	    refNanoDceL2SegQuotaMd.price_2bo_qty << ",";
    m_fileLevel2Stream << "price_2be_qty=" << 	    refNanoDceL2SegQuotaMd.price_2be_qty << ",";
    m_fileLevel2Stream << "price_2so_qty=" << 	    refNanoDceL2SegQuotaMd.price_2so_qty << ",";
    m_fileLevel2Stream << "price_2se_qty=" << 	    refNanoDceL2SegQuotaMd.price_2se_qty << ",";
    m_fileLevel2Stream << "price_3=" <<  			refNanoDceL2SegQuotaMd.price_3 << ",";
    m_fileLevel2Stream << "price_3bo_qty=" << 	    refNanoDceL2SegQuotaMd.price_3bo_qty << ",";
    m_fileLevel2Stream << "price_3be_qty=" << 	    refNanoDceL2SegQuotaMd.price_3be_qty << ",";
    m_fileLevel2Stream << "price_3so_qty=" << 	    refNanoDceL2SegQuotaMd.price_3so_qty << ",";
    m_fileLevel2Stream << "price_3se_qty=" << 	    refNanoDceL2SegQuotaMd.price_3se_qty << ",";
    m_fileLevel2Stream << "price_4=" <<  			refNanoDceL2SegQuotaMd.price_4 << ",";
    m_fileLevel2Stream << "price_4bo_qty=" << 	    refNanoDceL2SegQuotaMd.price_4bo_qty << ",";
    m_fileLevel2Stream << "price_4be_qty=" << 	    refNanoDceL2SegQuotaMd.price_4be_qty << ",";
    m_fileLevel2Stream << "price_4so_qty=" << 	    refNanoDceL2SegQuotaMd.price_4so_qty << ",";
    m_fileLevel2Stream << "price_4se_qty=" << 	    refNanoDceL2SegQuotaMd.price_4se_qty << ",";
    m_fileLevel2Stream << "price_5=" <<  			refNanoDceL2SegQuotaMd.price_5 << ",";
    m_fileLevel2Stream << "price_5bo_qty=" << 	    refNanoDceL2SegQuotaMd.price_5bo_qty << ",";
    m_fileLevel2Stream << "price_5be_qty=" << 	    refNanoDceL2SegQuotaMd.price_5be_qty << ",";
    m_fileLevel2Stream << "price_5so_qty=" << 	    refNanoDceL2SegQuotaMd.price_5so_qty << ",";
    m_fileLevel2Stream << "price_5se_qty=" << 	    refNanoDceL2SegQuotaMd.price_5se_qty << std::endl;
}


void CNanoDceMdSpiImpl::OnNanoDceL2OrderStatisticsMd(const NanoDceL2OrderStatisticsMdType& refNanoDceL2OrderStatisticsMd)
{
    m_fileLevel2Stream << "OnNanoDceL2OrderStatisticsMd" << ",";
    m_fileLevel2Stream << "contract_name=" <<         refNanoDceL2OrderStatisticsMd.contract_name << ",";
    m_fileLevel2Stream << "contract_no=" <<         refNanoDceL2OrderStatisticsMd.contract_no << ",";
    m_fileLevel2Stream << "trade_date=" <<          refNanoDceL2OrderStatisticsMd.trade_date << ",";
    m_fileLevel2Stream << "gen_time=" <<            refNanoDceL2OrderStatisticsMd.gen_time << ",";
    m_fileLevel2Stream << "total_buy_qty=" <<       refNanoDceL2OrderStatisticsMd.total_buy_qty << ",";
    m_fileLevel2Stream << "total_sell_qty=" <<      refNanoDceL2OrderStatisticsMd.total_sell_qty << ",";
    m_fileLevel2Stream << "weighted_avg_buy_px=" << refNanoDceL2OrderStatisticsMd.weighted_avg_buy_px << ",";
    m_fileLevel2Stream << "weighted_avg_sell_px=" <<refNanoDceL2OrderStatisticsMd.weighted_avg_sell_px << std::endl;
}


void CNanoDceMdSpiImpl::OnNanoDceL2DeepOrderVolumeMd(const NanoDceL2DeepOrderVolumeMdType& refDeepOrderVolumeMd)
{
    m_fileLevel2Stream << "OnNanoDceL2DeepOrderVolumeMd" << ",";
    m_fileLevel2Stream << "contract_name=" <<    refDeepOrderVolumeMd.contract_name << ",";
    m_fileLevel2Stream << "contract_no=" <<    refDeepOrderVolumeMd.contract_no << ",";
    m_fileLevel2Stream << "trade_date=" <<     refDeepOrderVolumeMd.trade_date << ",";
    m_fileLevel2Stream << "gen_time=" <<       refDeepOrderVolumeMd.gen_time << ",";
    m_fileLevel2Stream << "bid=" <<            refDeepOrderVolumeMd.bid << ",";
    m_fileLevel2Stream << "ask=" <<            refDeepOrderVolumeMd.ask << ",";
    m_fileLevel2Stream << "bid_qty_1=" <<      refDeepOrderVolumeMd.bid_qty_1 << ",";
    m_fileLevel2Stream << "bid_qty_2=" <<      refDeepOrderVolumeMd.bid_qty_2 << ",";
    m_fileLevel2Stream << "bid_qty_3=" <<      refDeepOrderVolumeMd.bid_qty_3 << ",";
    m_fileLevel2Stream << "bid_qty_4=" <<      refDeepOrderVolumeMd.bid_qty_4 << ",";
    m_fileLevel2Stream << "bid_qty_5=" <<      refDeepOrderVolumeMd.bid_qty_5 << ",";
    m_fileLevel2Stream << "bid_qty_6=" <<      refDeepOrderVolumeMd.bid_qty_6 << ",";
    m_fileLevel2Stream << "bid_qty_7=" <<      refDeepOrderVolumeMd.bid_qty_7 << ",";
    m_fileLevel2Stream << "bid_qty_8=" <<      refDeepOrderVolumeMd.bid_qty_8 << ",";
    m_fileLevel2Stream << "bid_qty_9=" <<      refDeepOrderVolumeMd.bid_qty_9 << ",";
    m_fileLevel2Stream << "bid_qty_10=" <<     refDeepOrderVolumeMd.bid_qty_10 << ",";
    m_fileLevel2Stream << "ask_qty_1=" <<      refDeepOrderVolumeMd.ask_qty_1 << ",";
    m_fileLevel2Stream << "ask_qty_2=" <<      refDeepOrderVolumeMd.ask_qty_2 << ",";
    m_fileLevel2Stream << "ask_qty_3=" <<      refDeepOrderVolumeMd.ask_qty_3 << ",";
    m_fileLevel2Stream << "ask_qty_4=" <<      refDeepOrderVolumeMd.ask_qty_4 << ",";
    m_fileLevel2Stream << "ask_qty_5=" <<      refDeepOrderVolumeMd.ask_qty_5 << ",";
    m_fileLevel2Stream << "ask_qty_6=" <<      refDeepOrderVolumeMd.ask_qty_6 << ",";
    m_fileLevel2Stream << "ask_qty_7=" <<      refDeepOrderVolumeMd.ask_qty_7 << ",";
    m_fileLevel2Stream << "ask_qty_8=" <<      refDeepOrderVolumeMd.ask_qty_8 << ",";
    m_fileLevel2Stream << "ask_qty_9=" <<      refDeepOrderVolumeMd.ask_qty_9 << ",";
    m_fileLevel2Stream << "ask_qty_10="<<      refDeepOrderVolumeMd.ask_qty_10 << std::endl;
}

void CNanoDceMdSpiImpl::OnNanoDceL2DeepQuoteMd(const NanoDceL2DeepQuoteMdType& refNanoDceL2DeepMd)
{
    m_fileLevel2Stream << "OnNanoDceL2DeepQuoteMd" << ",";
    m_fileLevel2Stream << "contract_name=" <<    refNanoDceL2DeepMd.contract_name << ",";
    m_fileLevel2Stream << "contract_no=" <<    refNanoDceL2DeepMd.contract_no << ",";
    m_fileLevel2Stream << "trade_date=" <<     refNanoDceL2DeepMd.trade_date << ",";
    m_fileLevel2Stream << "gen_time=" <<       refNanoDceL2DeepMd.gen_time << ",";
    m_fileLevel2Stream << "bid_1=" <<          refNanoDceL2DeepMd.bid_1 << ",";
    m_fileLevel2Stream << "bid_1_qty=" <<      refNanoDceL2DeepMd.bid_1_qty << ",";
    m_fileLevel2Stream << "bid_1_imp_qty=" <<  refNanoDceL2DeepMd.bid_1_imp_qty << ",";
    m_fileLevel2Stream << "bid_2=" <<          refNanoDceL2DeepMd.bid_2 << ",";
    m_fileLevel2Stream << "bid_2_qty=" <<      refNanoDceL2DeepMd.bid_2_qty << ",";
    m_fileLevel2Stream << "bid_2_imp_qty=" <<  refNanoDceL2DeepMd.bid_2_imp_qty << ",";
    m_fileLevel2Stream << "bid_3=" <<          refNanoDceL2DeepMd.bid_3 << ",";
    m_fileLevel2Stream << "bid_3_qty=" <<      refNanoDceL2DeepMd.bid_3_qty << ",";
    m_fileLevel2Stream << "bid_3_imp_qty=" <<  refNanoDceL2DeepMd.bid_3_imp_qty << ",";
    m_fileLevel2Stream << "bid_4=" <<          refNanoDceL2DeepMd.bid_4 << ",";
    m_fileLevel2Stream << "bid_4_qty=" <<      refNanoDceL2DeepMd.bid_4_qty << ",";
    m_fileLevel2Stream << "bid_4_imp_qty=" <<  refNanoDceL2DeepMd.bid_4_imp_qty << ",";
    m_fileLevel2Stream << "bid_5=" <<          refNanoDceL2DeepMd.bid_5 << ",";
    m_fileLevel2Stream << "bid_5_qty=" <<      refNanoDceL2DeepMd.bid_5_qty << ",";
    m_fileLevel2Stream << "bid_5_imp_qty=" <<  refNanoDceL2DeepMd.bid_5_imp_qty << ",";
    m_fileLevel2Stream << "ask_1=" <<          refNanoDceL2DeepMd.ask_1 << ",";
    m_fileLevel2Stream << "ask_1_qty=" <<      refNanoDceL2DeepMd.ask_1_qty << ",";
    m_fileLevel2Stream << "ask_1_imp_qty=" <<  refNanoDceL2DeepMd.ask_1_imp_qty << ",";
    m_fileLevel2Stream << "ask_2=" <<          refNanoDceL2DeepMd.ask_2 << ",";
    m_fileLevel2Stream << "ask_2_qty=" <<      refNanoDceL2DeepMd.ask_2_qty << ",";
    m_fileLevel2Stream << "ask_2_imp_qty=" <<  refNanoDceL2DeepMd.ask_2_imp_qty << ",";
    m_fileLevel2Stream << "ask_3=" <<          refNanoDceL2DeepMd.ask_3 << ",";
    m_fileLevel2Stream << "ask_3_qty=" <<      refNanoDceL2DeepMd.ask_3_qty << ",";
    m_fileLevel2Stream << "ask_3_imp_qty=" <<  refNanoDceL2DeepMd.ask_3_imp_qty << ",";
    m_fileLevel2Stream << "ask_4=" <<          refNanoDceL2DeepMd.ask_4 << ",";
    m_fileLevel2Stream << "ask_4_qty=" <<      refNanoDceL2DeepMd.ask_4_qty << ",";
    m_fileLevel2Stream << "ask_4_imp_qty=" <<  refNanoDceL2DeepMd.ask_4_imp_qty << ",";
    m_fileLevel2Stream << "ask_5=" <<          refNanoDceL2DeepMd.ask_5 << ",";
    m_fileLevel2Stream << "ask_5_qty=" <<      refNanoDceL2DeepMd.ask_5_qty << ",";
    m_fileLevel2Stream << "ask_5_imp_qty=" <<  refNanoDceL2DeepMd.ask_5_imp_qty << std::endl;
}