#pragma once

#include "NanoZceMdStruct.h"

#ifdef LIB_NANO_API_EXPORT
#define LIB_API_EXPORT __attribute__ ((visibility("default")))
#else
#define LIB_API_EXPORT
#endif

class INanoZceMdSpi
{
public:
    //五档行情回调接口
    virtual void OnNanoZceL2Md(const NanoZceL2MdType& refNanoZceL2Md) = 0;
    virtual void OnNanoZceL2ArbMd(const NanoZceL2ArbMdType& refNanoZceL2ArbMd) = 0;

    //一档行情回调接口
    virtual void OnNanoZceL1Md(const NanoZceL1MdType& refNanoZceL1Md) = 0;
    virtual void OnNanoZceL1ArbMd(const NanoZceL1ArbMdType& refNanoZceL1ArbMd) = 0;
};

class LIB_API_EXPORT INanoZceMdApi
{
public:
    static INanoZceMdApi& CreateNanoZceMdApi();
    static void DestroyNanoZceMdApi(INanoZceMdApi& refNanoZceMdApi);

    /*********************************************阻塞接口*********************************************/
    /*
    @description 阻塞启动(复用调用线程，不额外启动线程。使用仅需调用NanoRecvStart即可，内部会循环获取DMA数据并回调给用户层)
    @param      refNanoZceMdSpi    回调实例对象引用
    @param      lpConfig           配置文件(默认当前路径，非当前路径请指定路径)
                                NULL:默认当前路径的config.ini文件
								其他:配置文件路径名
    @return     0:成功      其他:失败
    注意：
    1 集合竞价时间之前务必使该接口处于运行状态，否则FPGA可能会丢失掉订阅报文，导致后面丢失订阅结果!!
    2 集合竞价时间之后，也尽可能让该接口处于运行状态，否则大量数据的时候，FPGA缓冲不足会导致订阅结果丢失!!
    */
    virtual int32_t NanoRecvStart(INanoZceMdSpi& refNanoZceMdSpi, const char* lpConfig) = 0;


    /*********************************************非阻塞接口*********************************************/
    //非阻塞启动(复用调用线程，不额外启动线程。使用先调用NanoStart，调用NanoInit成功后需循环调用NanoRecv从DMA获取数据，回调函数要尽快返回，否则网络数据量很大的时候会造成DMA数据丢失
    /*
    @description 启动Nano服务，完成初始化
    @param      refNanoZceMdSpi    回调实例对象引用
    @param      lpConfig            配置文件(默认当前路径，非当前路口请指定路径)
    			lpConfig=NULL, 默认使用当给钱路径的config.ini文件
    			其他:配置文件路径名
    @return     0:成功  其他:失败
    */
    virtual int32_t NanoStart(INanoZceMdSpi& refNanoZceMdSpi, const char* lpConfig) = 0;

    /*
    @description 非阻塞，NanoRecv从DMA获取数据并OnNanoZceMd回调给应用层，
    @return      0:不触发回调，没有数据
                 1:触发回调，有数据
                -1:程序退出，外层可以把-1作为SIGINT信号使用

    注意: 1 回调函数处于FPGA回调的上下文，要尽快返回，否则网络数据量很大的时候会造成后面的DMA数据丢失!
          2 该接口调用频率要尽可能的高，否则FPGA内部缓冲有限，大量数据包情况下，不及时取走也会导致DMA数据丢失!
          3 有数据时候，回调函数执行完毕后，NanoRecv才返回1。注意是有先后顺序的。
          4 集合竞价时间之前务必循环调用该接口，否则FPGA可能会丢失掉订阅报文，导致后面丢失订阅结果!!
    */
    virtual int32_t NanoRecv() = 0;
};

