#include "NanoShfeMdApi.h"
#include <cstdio>
#include <cstdlib>
#include <time.h>
#include <thread>
#include <fstream>
#include <arpa/inet.h>

class CNanoShfeMdSpiImpl : public CNanoShfeMdSpi
{
public:
    CNanoShfeMdSpiImpl(int32_t instanceIndex);
    ~CNanoShfeMdSpiImpl();
public:
    virtual void OnNanoShfeMd(const NanoShfeMdType& refSNanoShfeMd);
private:
    int32_t _CreateShowFile();

private:
    std::ofstream           m_fileStream;       //行情落地文件流对象
    int32_t                 m_instanceIndex = 0;
};


void NanoChannelFunc(int32_t instanceIndex)
{
    printf("NanoChannelFunc: %d......start\n", instanceIndex);
    CNanoShfeMdSpiImpl mdSpi(instanceIndex);
    CNanoShfeMdApi& refNanoShfeMdApi = CNanoShfeMdApi::CreateNanoShfeMdApi();

    char szBuf[32] = {};
    sprintf(szBuf, "config_%d.ini", instanceIndex);

    //阻塞示例
    #if 1
    {
        printf("NanoChannelFunc: %d 阻塞模式\n", instanceIndex);
        refNanoShfeMdApi.NanoRecvStart(mdSpi, szBuf);
    }
    #endif

    //非阻塞示例
    #if 0
    {
        printf("NanoChannelFunc: %d 非阻塞模式\n", instanceIndex);
        if (0 != refNanoShfeMdApi.NanoStart(mdSpi, szBuf))
        {
            printf("NanoChannelFunc: %d NanoStart failed\n", instanceIndex);
            return;
        }

        int32_t nRet = -1;
        while (-1 != (nRet = refNanoShfeMdApi.NanoRecv()))
        {
            if (0 == nRet)
            {
                //printf("NanoChannelFunc: %d none dma data\n", instanceIndex);
            }
        }
    }
    #endif

    //非回调示例
    #if 0
    {
        printf("NanoChannelFunc: %d 非回调模式\n", instanceIndex);
        if (0 != refNanoShfeMdApi.NanoStart(szBuf))
        {
            printf("NanoChannelFunc: %d NanoStart failed\n", instanceIndex);
            return;
        }

        NanoShfeMdType nanoShfeMd = {};
        int32_t nRet = -1;
        while (-1 != (nRet = refNanoShfeMdApi.NanoRecv(nanoShfeMd)))
        {
            if (1 == nRet)
            {
                mdSpi.OnNanoShfeMd(nanoShfeMd);
            }
        }
    }
    #endif

	CNanoShfeMdApi::DestroyNanoShfeMdApi(refNanoShfeMdApi);
    printf("NanoChannelFunc: %d......end\n", instanceIndex);
}

int32_t main(int32_t argc, char** argv)
{
    if (argc < 2)
    {
        printf("Usage: %s Count\n", argv[0]);
        return -1;
    }

    int32_t InstanceCount = atoi(argv[1]);
    if ((InstanceCount < 1) || (InstanceCount > 16))
    {
        //Count ∈ [1~16]
        printf("Usage: %s Count ∈ [1~16]\n", argv[0]);
        return -1;
    }

    std::thread threadArray[16];
    for (int32_t index = 0; index < InstanceCount; ++index)
    {
        threadArray[index] = std::thread(NanoChannelFunc, index);
    }
    
    for (int32_t index = 0; index < InstanceCount; ++index)
    {
        threadArray[index].join();
    }

    return 0;
}


CNanoShfeMdSpiImpl::CNanoShfeMdSpiImpl(int32_t instanceIndex)
    : m_instanceIndex(instanceIndex)
{
    _CreateShowFile();
}

CNanoShfeMdSpiImpl::~CNanoShfeMdSpiImpl()
{
    if (m_fileStream.is_open())
    {
        m_fileStream.flush();
        m_fileStream.close();
    }
}

void CNanoShfeMdSpiImpl::OnNanoShfeMd(const NanoShfeMdType& refSNanoShfeMd)
{
    m_fileStream << "OnNanoShfeMd" << ",";
    m_fileStream << "inst_no=" <<             refSNanoShfeMd.inst_no              << ",";
    m_fileStream << "inst_id=" <<             refSNanoShfeMd.inst_id              << ",";
    m_fileStream << "update_time=" <<         refSNanoShfeMd.update_time          << ",";
    m_fileStream << "update_milli_sec=" <<    refSNanoShfeMd.update_milli_sec     << ",";
    m_fileStream << "type=" <<                refSNanoShfeMd.type                 << ",";
    m_fileStream << "change_no=" <<           refSNanoShfeMd.change_no            << ",";
    m_fileStream << "last_px=" <<             refSNanoShfeMd.last_px              << ",";
    m_fileStream << "volume=" <<              refSNanoShfeMd.volume               << ",";
    m_fileStream << "turnover=" <<            refSNanoShfeMd.turnover             << ",";
    m_fileStream << "open_interest=" <<       refSNanoShfeMd.open_interest        << ",";
    m_fileStream << "bid1_px=" <<             refSNanoShfeMd.bid1_px              << ",";
    m_fileStream << "bid1_vol=" <<            refSNanoShfeMd.bid1_vol             << ",";
    m_fileStream << "bid2_px=" <<             refSNanoShfeMd.bid2_px              << ",";
    m_fileStream << "bid2_vol=" <<            refSNanoShfeMd.bid2_vol             << ",";
    m_fileStream << "bid3_px=" <<             refSNanoShfeMd.bid3_px              << ",";
    m_fileStream << "bid3_vol=" <<            refSNanoShfeMd.bid3_vol             << ",";
    m_fileStream << "bid4_px=" <<             refSNanoShfeMd.bid4_px              << ",";
    m_fileStream << "bid4_vol=" <<            refSNanoShfeMd.bid4_vol             << ",";
    m_fileStream << "bid5_px=" <<             refSNanoShfeMd.bid5_px              << ",";
    m_fileStream << "bid5_vol=" <<            refSNanoShfeMd.bid5_vol             << ",";
    m_fileStream << "ask1_px=" <<             refSNanoShfeMd.ask1_px              << ",";
    m_fileStream << "ask1_vol=" <<            refSNanoShfeMd.ask1_vol             << ",";
    m_fileStream << "ask2_px=" <<             refSNanoShfeMd.ask2_px              << ",";
    m_fileStream << "ask2_vol=" <<            refSNanoShfeMd.ask2_vol             << ",";
    m_fileStream << "ask3_px=" <<             refSNanoShfeMd.ask3_px              << ",";
    m_fileStream << "ask3_vol=" <<            refSNanoShfeMd.ask3_vol             << ",";
    m_fileStream << "ask4_px=" <<             refSNanoShfeMd.ask4_px              << ",";
    m_fileStream << "ask4_vol=" <<            refSNanoShfeMd.ask4_vol             << ",";
    m_fileStream << "ask5_px=" <<             refSNanoShfeMd.ask5_px              << ",";
    m_fileStream << "ask5_vol=" <<            refSNanoShfeMd.ask5_vol             << ",";
    //m_fileStream << "reverse=" <<             refSNanoShfeMd.reverse              << ",";
    m_fileStream << "last_tick_flag=" <<      refSNanoShfeMd.last_tick_flag       << ",";
    m_fileStream << "max_inst_no=" <<         refSNanoShfeMd.max_inst_no          << std::endl;
}

int32_t CNanoShfeMdSpiImpl::_CreateShowFile()
{
    char file_name[256] = {};
    time_t time_now = {};
    time(&time_now);
    struct tm *tm_now = localtime(&time_now);

    sprintf(file_name, "nano_u50_channel%d_%04d%02d%02d_%02d%02d%02d.csv", m_instanceIndex, tm_now->tm_year + 1900, tm_now->tm_mon + 1, tm_now->tm_mday, tm_now->tm_hour, tm_now->tm_min, tm_now->tm_sec);
    m_fileStream.open(file_name);
    m_fileStream.precision(6);
    m_fileStream.setf(std::ios::uppercase|std::ios::scientific);

    return 0;
}