#include "NanoGfexMdApi.h"
#include <cstdio>
#include <cstdlib>
#include <time.h>
#include <thread>
#include <fstream>
#include <iostream>
#include <iomanip>

class CNanoGfexMdSpiImpl : public CNanoGfexMdSpi
{
public:
    CNanoGfexMdSpiImpl(int32_t instanceIndex);
    ~CNanoGfexMdSpiImpl();
public:
    //一档行情回调接口
    virtual void OnNanoGfexL1Md(const NanoGfexL1MdType& refNanoGfexL1Md);

    //五档行情回调接口
    virtual void OnNanoGfexL2Md(const NanoGfexL2MdType& refNanoGfexL2Md);

public:
    void ShowInstStaticInfo(const NanoGfexInstStaticInfo& refInstStaticInfo);

private:
    int32_t _CreateShowFile();

private:
    std::ofstream           m_fileLevel1Stream;       //一档落地文件流对象
    std::ofstream           m_fileLevel2Stream;       //五档落地文件流对象
    int32_t                 m_instanceIndex = 0;
};


void NanoGfexFunc(int32_t instanceIndex)
{
    printf("NanoDceFunc: %d......start\n", instanceIndex);
    CNanoGfexMdSpiImpl mdSpi(instanceIndex);
    CNanoGfexMdApi& refNanoGfexMdApi = CNanoGfexMdApi::CreateNanoGfexMdApi();

    char szBuf[32] = {};
    sprintf(szBuf, "config_%d.ini", instanceIndex);

    //阻塞示例
    #if 0
    {
        printf("NanoGfexFunc: %d 阻塞模式\n", instanceIndex);
        refNanoGfexMdApi.NanoRecvStart(mdSpi, szBuf);
    }
    #endif

    //非阻塞示例
    #if 1
    {
        printf("NanoGfexFunc: %d 非阻塞模式\n", instanceIndex);
        if (0 != refNanoGfexMdApi.NanoStart(mdSpi, szBuf))
        {
            printf("NanoGfexFunc: NanoStart failed\n");
            return;
        }
        
        //获取合约静态信息
        NanoGfexInstStaticInfo refInstStaticInfo = {};
        if (0 == refNanoGfexMdApi.GetInstStaticInfo("lc2402", refInstStaticInfo))
        {
            mdSpi.ShowInstStaticInfo(refInstStaticInfo);
        }

        if (0 == refNanoGfexMdApi.GetInstStaticInfo("si2409-P-15200", refInstStaticInfo))
        {
            mdSpi.ShowInstStaticInfo(refInstStaticInfo);
        }

        if (0 == refNanoGfexMdApi.GetInstStaticInfo("SP lc2402&lc2404", refInstStaticInfo))
        {
            mdSpi.ShowInstStaticInfo(refInstStaticInfo);
        }

        if (0 == refNanoGfexMdApi.GetInstStaticInfo("ag2405", refInstStaticInfo))
        {
            mdSpi.ShowInstStaticInfo(refInstStaticInfo);
        }

        if (0 == refNanoGfexMdApi.GetInstStaticInfo(nullptr, refInstStaticInfo))
        {
            mdSpi.ShowInstStaticInfo(refInstStaticInfo);
        }

        int32_t nRet = -1;
        while (-1 != (nRet = refNanoGfexMdApi.NanoRecv()))
        {
            if (0 == nRet)
            {
                //printf("NanoGfexFunc: none dma data\n");
            }
            else if (1 == nRet)
            {
                //printf("NanoGfexFunc: have dma data\n");
            }
        }
    }
    #endif

	CNanoGfexMdApi::DestroyNanoGfexMdApi(refNanoGfexMdApi);
    printf("NanoGfexFunc: ......end\n");
}

int32_t main(int32_t argc, char** argv)
{
    if (argc < 2)
    {
        printf("Usage: %s Count\n", argv[0]);
        return -1;
    }

    int32_t InstanceCount = atoi(argv[1]);
    if ((InstanceCount < 1) || (InstanceCount > 16))
    {
        //Count ∈ [1~16]
        printf("Usage: %s Count ∈ [1~16]\n", argv[0]);
        return -1;
    }

    std::thread threadArray[16];
    for (int32_t index = 0; index < InstanceCount; ++index)
    {
        threadArray[index] = std::thread(NanoGfexFunc, index);
    }
    
    for (int32_t index = 0; index < InstanceCount; ++index)
    {
        threadArray[index].join();
    }

    return 0;
}

CNanoGfexMdSpiImpl::CNanoGfexMdSpiImpl(int32_t instanceIndex)
    : m_instanceIndex(instanceIndex)
{
    _CreateShowFile();
}

CNanoGfexMdSpiImpl::~CNanoGfexMdSpiImpl()
{
    if (m_fileLevel1Stream.is_open())
    {
        m_fileLevel1Stream.flush();
        m_fileLevel1Stream.close();
    }

    if (m_fileLevel2Stream.is_open())
    {
        m_fileLevel2Stream.flush();
        m_fileLevel2Stream.close();
    }
}

int32_t CNanoGfexMdSpiImpl::_CreateShowFile()
{
    char file_name[256] = {};
    time_t time_now = {};
    time(&time_now);
    struct tm *tm_now = localtime(&time_now);

    //一档落地文件
    {
        sprintf(file_name, "nano_u50_level1_channel%d_%04d%02d%02d_%02d%02d%02d.csv", m_instanceIndex, tm_now->tm_year + 1900, tm_now->tm_mon + 1, tm_now->tm_mday, tm_now->tm_hour, tm_now->tm_min, tm_now->tm_sec);
        m_fileLevel1Stream.open(file_name);
        m_fileLevel1Stream.precision(6);
        m_fileLevel1Stream.setf(std::ios::uppercase|std::ios::scientific);
    }

    //五档落地文件
    {
        sprintf(file_name, "nano_u50_level2_channel%d_%04d%02d%02d_%02d%02d%02d.csv", m_instanceIndex, tm_now->tm_year + 1900, tm_now->tm_mon + 1, tm_now->tm_mday, tm_now->tm_hour, tm_now->tm_min, tm_now->tm_sec);
        m_fileLevel2Stream.open(file_name);
        m_fileLevel2Stream.precision(6);
        m_fileLevel2Stream.setf(std::ios::uppercase|std::ios::scientific);
    }

    return 0;
}

void CNanoGfexMdSpiImpl::ShowInstStaticInfo(const NanoGfexInstStaticInfo& refInstStaticInfo)
{
    std::cout << "ShowInstStaticInfo" << ",";
    std::cout << "contract_no=" << 			    refInstStaticInfo.contract_no << ",";
    std::cout << "contract_name=" << 		    refInstStaticInfo.contract_name << ",";
    std::cout << "trade_date=" << 		        refInstStaticInfo.trade_date << ",";
    std::cout << "init_open_interst=" << 		refInstStaticInfo.init_open_interst << ",";
    std::cout << "limit_up_px=" << 			    refInstStaticInfo.limit_up_px << ",";
    std::cout << "limit_down_px=" << 			refInstStaticInfo.limit_down_px << ",";
    std::cout << "last_settlement_price=" << 	refInstStaticInfo.last_settlement_price << ",";
    std::cout << "last_closing_price=" << 		refInstStaticInfo.last_closing_price << std::endl;
}

void CNanoGfexMdSpiImpl::OnNanoGfexL1Md(const NanoGfexL1MdType& refNanoGfexL1Md)
{
    m_fileLevel1Stream << "OnNanoGfexL1Md" << ",";
    m_fileLevel1Stream << "contract_no=" << 		refNanoGfexL1Md.contract_no << ",";
    m_fileLevel1Stream << "contract_name=" << 	    refNanoGfexL1Md.contract_name << ",";
    m_fileLevel1Stream << "send_time=" << 	        refNanoGfexL1Md.send_time << ",";
    m_fileLevel1Stream << "last_price=" <<          refNanoGfexL1Md.last_price << ",";
    m_fileLevel1Stream << "last_match_qty=" << 		refNanoGfexL1Md.last_match_qty << ",";
    m_fileLevel1Stream << "total_match_qty=" << 	refNanoGfexL1Md.total_match_qty << ",";
    m_fileLevel1Stream << "turn_over=" <<           refNanoGfexL1Md.turn_over << ",";
    m_fileLevel1Stream << "open_interest=" << 		refNanoGfexL1Md.open_interest << ",";
    m_fileLevel1Stream << "open_interest_change=" <<refNanoGfexL1Md.open_interest_change << ",";
    m_fileLevel1Stream << "bid_price=" <<           refNanoGfexL1Md.bid_price << ",";
    m_fileLevel1Stream << "bid_qty=" << 			refNanoGfexL1Md.bid_qty << ",";
    m_fileLevel1Stream << "ask_price=" <<           refNanoGfexL1Md.ask_price << ",";
    m_fileLevel1Stream << "ask_qty=" << 			refNanoGfexL1Md.ask_qty << ",";
    m_fileLevel1Stream << "avg_price=" <<           refNanoGfexL1Md.avg_price << std::endl;
}

void CNanoGfexMdSpiImpl::OnNanoGfexL2Md(const NanoGfexL2MdType& refNanoGfexL2Md)
{
    m_fileLevel2Stream << "OnNanoGfexL2Md" << ",";
    m_fileLevel2Stream << "contract_name=" <<        refNanoGfexL2Md.contract_name          << ",";
    m_fileLevel2Stream << "last_price=" <<           refNanoGfexL2Md.last_price           << ",";
    m_fileLevel2Stream << "last_match_qty=" <<       refNanoGfexL2Md.last_match_qty       << ",";
    m_fileLevel2Stream << "match_total_qty=" <<      refNanoGfexL2Md.match_total_qty      << ",";
    m_fileLevel2Stream << "turn_over=" <<            refNanoGfexL2Md.turn_over            << ",";
    m_fileLevel2Stream << "open_interest=" <<        refNanoGfexL2Md.open_interest        << ",";
    m_fileLevel2Stream << "open_interest_change=" << refNanoGfexL2Md.open_interest_change << ",";
    m_fileLevel2Stream << "gen_time=" <<             refNanoGfexL2Md.gen_time             << ",";
    m_fileLevel2Stream << "bid1_px=" <<              refNanoGfexL2Md.bid1_px              << ",";
    m_fileLevel2Stream << "bid1_vol=" <<             refNanoGfexL2Md.bid1_vol              << ",";
    m_fileLevel2Stream << "bid2_px=" <<              refNanoGfexL2Md.bid2_px              << ",";
    m_fileLevel2Stream << "bid2_vol=" <<             refNanoGfexL2Md.bid2_vol              << ",";
    m_fileLevel2Stream << "bid3_px=" <<              refNanoGfexL2Md.bid3_px              << ",";
    m_fileLevel2Stream << "bid3_vol=" <<             refNanoGfexL2Md.bid3_vol             << ",";
    m_fileLevel2Stream << "bid4_px=" <<              refNanoGfexL2Md.bid4_px             << ",";
    m_fileLevel2Stream << "bid4_vol=" <<             refNanoGfexL2Md.bid4_vol             << ",";
    m_fileLevel2Stream << "bid5_px=" <<              refNanoGfexL2Md.bid5_px             << ",";
    m_fileLevel2Stream << "bid5_vol=" <<             refNanoGfexL2Md.bid5_vol             << ",";
    m_fileLevel2Stream << "ask1_px=" <<              refNanoGfexL2Md.ask1_px              << ",";
    m_fileLevel2Stream << "ask1_vol=" <<             refNanoGfexL2Md.ask1_vol              << ",";
    m_fileLevel2Stream << "ask2_px=" <<              refNanoGfexL2Md.ask2_px              << ",";
    m_fileLevel2Stream << "ask2_vol=" <<             refNanoGfexL2Md.ask2_vol              << ",";
    m_fileLevel2Stream << "ask3_px=" <<              refNanoGfexL2Md.ask3_px              << ",";
    m_fileLevel2Stream << "ask3_vol=" <<             refNanoGfexL2Md.ask3_vol             << ",";
    m_fileLevel2Stream << "ask4_px=" <<              refNanoGfexL2Md.ask4_px             << ",";
    m_fileLevel2Stream << "ask4_vol=" <<             refNanoGfexL2Md.ask4_vol             << ",";
    m_fileLevel2Stream << "ask5_px=" <<              refNanoGfexL2Md.ask5_px             << ",";
    m_fileLevel2Stream << "ask5_vol=" <<             refNanoGfexL2Md.ask5_vol             << ",";
    m_fileLevel2Stream << "buy_imply_qty_1=" <<      refNanoGfexL2Md.buy_imply_qty_1      << ",";
    m_fileLevel2Stream << "buy_imply_qty_2=" <<      refNanoGfexL2Md.buy_imply_qty_2      << ",";
    m_fileLevel2Stream << "buy_imply_qty_3=" <<      refNanoGfexL2Md.buy_imply_qty_3      << ",";
    m_fileLevel2Stream << "buy_imply_qty_4=" <<      refNanoGfexL2Md.buy_imply_qty_4      << ",";
    m_fileLevel2Stream << "buy_imply_qty_5=" <<      refNanoGfexL2Md.buy_imply_qty_5      << ",";
    m_fileLevel2Stream << "sell_imply_qty_1=" <<     refNanoGfexL2Md.sell_imply_qty_1     << ",";
    m_fileLevel2Stream << "sell_imply_qty_2=" <<     refNanoGfexL2Md.sell_imply_qty_2     << ",";
    m_fileLevel2Stream << "sell_imply_qty_3=" <<     refNanoGfexL2Md.sell_imply_qty_3     << ",";
    m_fileLevel2Stream << "sell_imply_qty_4=" <<     refNanoGfexL2Md.sell_imply_qty_4     << ",";
    m_fileLevel2Stream << "sell_imply_qty_5=" <<     refNanoGfexL2Md.sell_imply_qty_5     << std::endl;
}