/// @file
#pragma once

#include <string>

#include <enyx/hw_c/version.h>
#include <enyx/hw/namespace.hpp>

/// @copydoc ENYX_HW_C_VERSION
#define ENYX_HW_VERSION ENYX_HW_C_VERSION
/// @copydoc ENYX_HW_C_VERSION
#define ENYX_HW_VERSION_MAJOR ENYX_HW_C_VERSION_MAJOR
/// @copydoc ENYX_HW_C_VERSION
#define ENYX_HW_VERSION_MINOR ENYX_HW_C_VERSION_MINOR
/// @copydoc ENYX_HW_C_VERSION
#define ENYX_HW_VERSION_PATCH ENYX_HW_C_VERSION_PATCH
/// @copydoc ENYX_HW_C_VERSION_CHECK
#define ENYX_HW_VERSION_CHECK ENYX_HW_C_VERSION_CHECK

ENYX_HW_NAMESPACE_BEGIN

/**
 * @copydoc enyx_hw_version
 */
std::string
version(void);

/**
 * @copydoc enyx_hw_version_check
 */
void
check_version(uint8_t major, uint8_t minor, uint8_t patch);

ENYX_HW_NAMESPACE_END

#include <enyx/hw/version.ipp>
