ENYX_HW_NAMESPACE_BEGIN

inline shared_mutex::shared_mutex(std::string const & name)
    :mutex_c_{::enyx_hw_shared_mutex_create(name.c_str())}
{
    if (mutex_c_ == nullptr)
        throw std::system_error{errno, std::generic_category()};
}

inline bool
shared_mutex::try_lock() noexcept
{
    auto res = ::enyx_hw_shared_mutex_trylock(handle());
    if (res == 0)
        return true;

    if (errno == EBUSY)
        return false;

    throw std::system_error{errno, std::generic_category()};
}

inline void
shared_mutex::lock() noexcept
{
    if (::enyx_hw_shared_mutex_lock(handle()) < 0)
        throw std::system_error{errno, std::generic_category()};
}

inline void
shared_mutex::unlock() noexcept
{
    if (::enyx_hw_shared_mutex_unlock(handle()) < 0)
        throw std::system_error{errno, std::generic_category()};
}

inline ::enyx_hw_shared_mutex const *
shared_mutex::handle() const noexcept
{
    return mutex_c_.get();
}

inline ::enyx_hw_shared_mutex *
shared_mutex::handle() noexcept
{
    return mutex_c_.get();
}

ENYX_HW_NAMESPACE_END
