ENYX_HW_NAMESPACE_BEGIN

namespace mocking {

inline
c2a_stream_interface::c2a_stream_interface()
    : handle_(new ::enyx_hwm_c2a_stream_interface())
{
    handle_->context = this;

    handle_->on_create = [] (void * context) {
        auto thiz = reinterpret_cast<c2a_stream_interface*>(context);

        if (! thiz->on_create)
            return 0;

        return thiz->on_create();
    };

    handle_->on_destroy = [] (void * context) {
        auto thiz = reinterpret_cast<c2a_stream_interface*>(context);

        if (! thiz->on_destroy)
            return;
        thiz->on_destroy();
    };

    handle_->get_uid = [] (void * context, char * buffer, size_t capacity) {
        auto thiz = reinterpret_cast<c2a_stream_interface*>(context);

        if (! thiz->get_uid) {
            errno = ENOSYS;
            return -1;
        }

        std::strncpy(buffer, thiz->get_uid().c_str(), capacity);
        return 0;
    };

    handle_->get_name = [] (void * context, char * buffer, size_t capacity) {
        auto thiz = reinterpret_cast<c2a_stream_interface*>(context);

        if (! thiz->get_name) {
            errno = ENOSYS;
            return -1;
        }

        std::strncpy(buffer, thiz->get_name().c_str(), capacity);
        return 0;
    };

    handle_->get_mtu = [] (void * context, uint32_t * mtu) {
        auto thiz = reinterpret_cast<c2a_stream_interface*>(context);

        if (! thiz->get_mtu) {
            errno = ENOSYS;
            return -1;
        }

        *mtu = thiz->get_mtu();
        return 0;
    };

    handle_->get_size = [] (void * context) -> ssize_t {
        auto thiz = reinterpret_cast<c2a_stream_interface*>(context);

        if (! thiz->get_size) {
            errno = ENOSYS;
            return -1;
        }

        return thiz->get_size();
    };

    handle_->send = [] (void * context, void const * data, uint32_t size) {
        auto thiz = reinterpret_cast<c2a_stream_interface*>(context);

        if (! thiz->send) {
            errno = ENOSYS;
            return -1;
        }

        return thiz->send(data, size);
    };

    handle_->send2 = [] (void * context, void const * data, uint32_t size,
                         enyx_hw_c2a_stream_flags flags) {
        auto thiz = reinterpret_cast<c2a_stream_interface*>(context);

        if (! thiz->send2) {
            errno = ENOSYS;
            return -1;
        }

        return thiz->send2(data, size, flags);
    };

    handle_->send_io_vec = [] (void * context,
                               enyx_hw_c2a_stream_io_vec const * vectors,
                               uint32_t vector_count) {
        auto thiz = reinterpret_cast<c2a_stream_interface*>(context);

        if (! thiz->send_io_vec) {
            errno = ENOSYS;
            return -1;
        }

        return thiz->send_io_vec(vectors, vector_count);
    };

    handle_->send_io_vec2 = [] (void * context,
                                enyx_hw_c2a_stream_io_vec const * vectors,
                                uint32_t vector_count,
                                enyx_hw_c2a_stream_flags flags) {
        auto thiz = reinterpret_cast<c2a_stream_interface*>(context);

        if (! thiz->send_io_vec2) {
            errno = ENOSYS;
            return -1;
        }

        return thiz->send_io_vec2(vectors, vector_count, flags);
    };

    handle_->is_ready = [] (void * context) {
        auto thiz = reinterpret_cast<c2a_stream_interface*>(context);

        if (! thiz->is_ready)
            return true;

        return thiz->is_ready();
    };

    handle_->is_idle = [] (void * context) {
        auto thiz = reinterpret_cast<c2a_stream_interface*>(context);

        if (! thiz->is_idle)
            return true;

        return thiz->is_idle();
    };

    handle_->wait_until_idle = [] (void * context, uint32_t us_timeout) {
        auto thiz = reinterpret_cast<c2a_stream_interface*>(context);

        if (! thiz->wait_until_idle) {
            errno = ENOSYS;
            return -1;
        }

        return thiz->wait_until_idle(us_timeout);
    };
}

inline ::enyx_hwm_c2a_stream_interface *
c2a_stream_interface::handle() noexcept
{
    return handle_.get();
}

inline ::enyx_hwm_c2a_stream_interface const *
c2a_stream_interface::handle() const noexcept
{
    return handle_.get();
}

} /* namespace mocking */

ENYX_HW_NAMESPACE_END
