ENYX_HW_NAMESPACE_BEGIN

inline std::error_category const&
category() noexcept
{
    static struct : std::error_category
    {
        virtual const char*
        name() const noexcept override
        {
            return "hw";
        }

        virtual std::string
        message(int condition) const override
        {
            switch (condition)
            {
            case UNIMPLEMENTED: return "unimplemented";
            default: throw std::runtime_error{"unknown error code"};
            };
        }
    } category_;

    return category_;
}

inline std::error_code
make_error_code(errc e)
{
    return std::error_code{static_cast<int>(e), category()};
}

ENYX_HW_NAMESPACE_END
