ENYX_HW_NAMESPACE_BEGIN

inline result<std::uint32_t>
a2c_stream::get_mtu() const noexcept
{
    std::uint32_t ret;
    if (enyx_hw_a2c_stream_get_mtu(handle(), &ret) != 0)
        return {std::error_code{errno, std::generic_category()}};
    return {ret};
}

inline result<std::size_t>
a2c_stream::get_size() const noexcept
{
    std::size_t ret;
    if (enyx_hw_a2c_stream_get_size(handle(), &ret) != 0)
        return {std::error_code{errno, std::generic_category()}};
    return {ret};
}

inline result<std::uint32_t>
a2c_stream::get_packet_count() const noexcept
{
    std::uint32_t ret;
    if (enyx_hw_a2c_stream_stats_get_packet_count(handle(), &ret) != 0)
        return {std::error_code{errno, std::generic_category()}};
    return {ret};
}

inline result<std::uint32_t>
a2c_stream::get_backpressure() const noexcept
{
    std::uint32_t ret;
    if (enyx_hw_a2c_stream_stats_get_backpressure(handle(), &ret) != 0)
        return {std::error_code{errno, std::generic_category()}};
    return {ret};
}

inline result<std::uint32_t>
a2c_stream::get_fifo_errors() const noexcept
{
    std::uint32_t ret;
    if (enyx_hw_a2c_stream_stats_get_fifo_errors(handle(), &ret) != 0)
        return {std::error_code{errno, std::generic_category()}};
    return {ret};
}

inline result<std::uint32_t>
a2c_stream::get_truncated_count() const noexcept
{
    std::uint32_t ret;
    if (enyx_hw_a2c_stream_stats_get_truncated_count(handle(), &ret) != 0)
        return {std::error_code{errno, std::generic_category()}};
    return {ret};
}

inline result<std::uint32_t>
a2c_stream::get_errors() const noexcept
{
    std::uint32_t ret;
    if (enyx_hw_a2c_stream_stats_get_errors(handle(), &ret) != 0)
        return {std::error_code{errno, std::generic_category()}};
    return {ret};
}

inline result<std::uint32_t>
a2c_stream::get_usage() const noexcept
{
    std::uint32_t ret;
    if (enyx_hw_a2c_stream_stats_get_usage(handle(), &ret) != 0)
        return {std::error_code{errno, std::generic_category()}};
    return {ret};
}

template<typename Handler>
inline
a2c_stream::poller<Handler>::poller(
        std::shared_ptr<enyx_hw_a2c_stream> a2c_stream_handle,
        Handler && handler)
    : ptr_(a2c_stream_handle),
      handle_(ptr_.get()),
      handler_(std::forward<Handler>(handler))
{ }

inline
a2c_stream::a2c_stream(a2c_stream_descriptor const& descriptor)
    : accelerator_(descriptor.get_accelerator()),
      a2c_stream_(enyx_hw_a2c_stream_create(descriptor.handle(), nullptr),
                  &enyx_hw_a2c_stream_destroy)
{
    if (a2c_stream_ == nullptr)
        throw std::system_error{errno, std::generic_category()};
}

inline
a2c_stream::a2c_stream(a2c_stream_descriptor const& descriptor,
                       a2c_stream_configuration const& configuration)
    : accelerator_(descriptor.get_accelerator()),
      a2c_stream_(enyx_hw_a2c_stream_create(descriptor.handle(), &configuration),
                  &enyx_hw_a2c_stream_destroy)
{
    if (a2c_stream_ == nullptr)
        throw std::system_error{errno, std::generic_category()};
}

template<typename Handler>
inline a2c_stream::poller<Handler>
a2c_stream::get_poller(Handler && handler)
{
    return {a2c_stream_, std::forward<Handler>(handler)};
}

inline a2c_stream_descriptor
a2c_stream::get_descriptor() const noexcept
{
    return {accelerator_, enyx_hw_a2c_stream_get_descriptor(handle())};
}

inline enyx_hw_a2c_stream *
a2c_stream::handle() noexcept
{
    return a2c_stream_.get();
}

inline enyx_hw_a2c_stream const *
a2c_stream::handle() const noexcept
{
    return a2c_stream_.get();
}

template<typename Handler>
inline size_t
a2c_stream::poller<Handler>::poll_once() noexcept
{
    return enyx_hw_a2c_stream_poll_once(handle_, on_data, this);
}

template<typename Handler>
inline void
a2c_stream::poller<Handler>::on_data(std::uint8_t const * data, std::uint32_t size, void * opaque)
{
    auto thiz = reinterpret_cast<poller<Handler> *>(opaque);
    thiz->handler_(data, size);
}

ENYX_HW_NAMESPACE_END
