#pragma once
#include <string>
#include <ostream>

namespace enyx::fix::utils {

struct joiner {

    joiner(char c)
        : joiner{std::string{c}}
    {}

    joiner(std::string const & delim)
        : first(true)
        , delim(delim)
    {}

    std::string
    consume() {
        if (first) {
            first = false;
            return "";
        }
        return delim;
    }

    bool first;
    std::string delim;
};

inline
std::ostream& operator<<(std::ostream & os, utils::joiner & joiner)
{
    return os << joiner.consume();
}

};
