#pragma once

#include <iostream>

namespace enyx::fix::reject {
enum class Reason {
    INVALID_TAG_NUMBER = 0,
    REQUIRED_TAG_MISSING = 1,
    TAG_NOT_DEFINED_FOR_THIS_MESSAGE_TYPE = 2,
    UNDEFINED_TAG = 3,
    TAG_SPECIFIED_WITHOUT_A_VALUE = 4,
    VALUE_IS_INCORRECT = 5,
    INCORRECT_DATA_FORMAT_FOR_VALUE = 6,
    DECRYPTION_PROBLEM = 7,
    SIGNATURE_PROBLEM = 8,
    COMPID_PROBLEM = 9,
    SENDINGTIME_ACCURACY_PROBLEM = 10,
    INVALID_MSGTYPE = 11,
    TAG_APPEARS_MORE_THAN_ONCE = 13,
    TAG_SPECIFIED_OUT_OF_REQUIRED_ORDER = 14,
    REPEATING_GROUP_FIELDS_OUT_OF_ORDER = 15,
    INCORRECT_NUMINGROUP_COUNT_FOR_REPEATING_GROUP = 16,
    NON_DATA_VALUE_INCLUDES_FIELD_DELIMITER = 17,
    OTHER = 99,
};

inline
std::ostream & operator<<(std::ostream & os, Reason const & reason)
{
    switch (reason) {
    case Reason::INVALID_TAG_NUMBER:
        os << "Invalid tag number";
        break;
    case Reason::REQUIRED_TAG_MISSING:
        os << "Required tag missing";
        break;
    case Reason::TAG_NOT_DEFINED_FOR_THIS_MESSAGE_TYPE:
        os << "Tag not defined for this message type";
        break;
    case Reason::UNDEFINED_TAG:
        os << "Undefined Tag";
        break;
    case Reason::TAG_SPECIFIED_WITHOUT_A_VALUE:
        os << "Tag specified without a value";
        break;
    case Reason::VALUE_IS_INCORRECT:
        os << "Value is incorrect (out of range) for this tag";
        break;
    case Reason::INCORRECT_DATA_FORMAT_FOR_VALUE:
        os << "Incorrect data format for value";
        break;
    case Reason::DECRYPTION_PROBLEM:
        os << "Decryption problem";
        break;
    case Reason::SIGNATURE_PROBLEM:
        os << "Signature problem";
        break;
    case Reason::COMPID_PROBLEM:
        os << "CompID problem";
        break;
    case Reason::SENDINGTIME_ACCURACY_PROBLEM:
        os << "SendingTime accuracy problem";
        break;
    case Reason::INVALID_MSGTYPE:
        os << "Invalid MsgType";
        break;
    case Reason::TAG_APPEARS_MORE_THAN_ONCE:
        os << "Tag appears more than once";
        break;
    case Reason::TAG_SPECIFIED_OUT_OF_REQUIRED_ORDER:
        os << "Tag specified out of required order";
        break;
    case Reason::REPEATING_GROUP_FIELDS_OUT_OF_ORDER:
        os << "Repeating group fields out of order";
        break;
    case Reason::INCORRECT_NUMINGROUP_COUNT_FOR_REPEATING_GROUP:
        os << "Incorrect NumInGroup count for repeating group";
        break;
    case Reason::NON_DATA_VALUE_INCLUDES_FIELD_DELIMITER:
        os << "Non 'data' value includes field delimiter (SOH character)";
        break;
    default:
        break;
    }
    return os;
}
}
