#pragma once

#include <enyx/hw/accelerator.hpp>
#include <enyx/hw/accelerator_descriptor.hpp>
#include <enyx/hw/core.hpp>
#include <enyx/fix/fix_model.hpp>
#include <enyx/hw/core_tree.hpp>
#include <enyx/hw/mmio.hpp>

namespace enyx::fix {

/**
 * High level abstraction to configure HW fix engine
 */
class engine {
public:
    engine(hw::accelerator_descriptor & acc_desc);

    void
    load_model(model::fix_model const & model);

private:
    hw::accelerator acc_;
    hw::mmio mmio_;
    hw::core_tree tree_;
    hw::core root_;
};

}
