#pragma once

#include <iosfwd>
#include <vector>

#include <enyx/cores/namespace.hpp>

ENYX_CORES_NAMESPACE_BEGIN

template<typename Type>
class Range
{
public:
    using ValueType = Type;

public:
    Range(void) = default;

    Range(const ValueType & value)
        : low_(value), high_(value)
    { }

    Range(const ValueType & low, const ValueType & high)
        : low_(low), high_(high)
    { }

    ValueType
    low() const
    { return low_; }

    ValueType
    high() const
    { return high_; }

private:
    ValueType low_;
    ValueType high_;
};

template<typename Type>
std::istream &
operator>>(std::istream & in, Range<Type> & range);

template<typename Type>
std::ostream &
operator<<(std::ostream & out, const Range<Type> & range);

template<typename Type>
std::vector<Type>
as_sequence(const Range<Type> & range);

ENYX_CORES_NAMESPACE_END

#include "Range.ipp"
