#include "Error.hpp"

ENYX_CORES_NAMESPACE_BEGIN

namespace {

struct category final : std::error_category
{
    category()
        : std::error_category()
    { }

    virtual const char*
    name() const noexcept
    {
        return "tester";
    }

    virtual std::string
    message(int condition) const
    {
        switch (condition)
        {
        case error::success: return "Success";
        case error::generic_fault: return "Generic fault";
        case error::unexpected_eof: return "Unexpected Eof";
        case error::checksum_failed: return "Checksum failed";
        case error::test_timeout: return "Test timeout";
        case error::unexpected_data: return "Unexpected data";
        default: return "Unknown error";
        }
    }
};

} // anonymous namespace

const std::error_category &
tester_category()
{
    static const category c;
    return c;
}

namespace error {

std::error_code
make_error_code(Error e)
{ return std::error_code(e, tester_category()); }

} // namespace error

ENYX_CORES_NAMESPACE_END
