#include "Executable.hpp"

#include <cstring>
#include <cstdint>

#include <stdexcept>
#include <sstream>

#include <enyx/cores/namespace.hpp>

#include "Color.hpp"
#include "Application.hpp"

ENYX_CORES_NAMESPACE_BEGIN

namespace Executable {

void
run(int argc, char** argv)
{
    std::string accelerator{"0"};
    Application::StackType stack_type{};
    std::uint32_t stack_index{};
    ColorConfiguration color = ColorConfiguration::AUTO;

    int i = 1;
    for (; i != argc && *argv[i] == '-'; ++i)
    {
        if (is_prefix(argv[i], "--accelerator-id") ||
            is_prefix(argv[i], "--accelerator-index") ||
            ! std::strcmp(argv[i], "-a"))
        {
            if (++i == argc)
                throw std::runtime_error{"'--accelerator-id' requires "
                                         "an argument"};

            accelerator = argv[i];
        }
        else if (is_prefix(argv[i], "--stack-type") ||
                ! std::strcmp(argv[i], "-t"))
        {
            if (++i == argc)
                throw std::runtime_error{"'--stack-type' requires "
                                         "an argument"};

            std::istringstream{argv[i]} >> stack_type;
        }
        else if (is_prefix(argv[i], "--stack-index") ||
                ! std::strcmp(argv[i], "-s"))
        {
            if (++i == argc)
                throw std::runtime_error{"'--stack-index' requires "
                                         "an argument"};

            stack_index = std::atoi(argv[i]);
        }
        else if (is_prefix(argv[i], "--color") ||
                 ! std::strcmp(argv[i], "-c"))
        {
            if (++i == argc)
                throw std::runtime_error{"'--color' requires either "
                                         "never, always or auto"};

            std::istringstream{argv[i]} >> color;
        }
        else if (is_prefix(argv[i], "--help") ||
                ! std::strcmp(argv[i], "-h"))
            throw std::runtime_error{"Try '" BIN_NAME " help'"};
        else
        {
            std::ostringstream error;
            error << "Unknown option '" << argv[i]
                  << "', try " BIN_NAME " help";
            throw std::runtime_error{error.str()};
        }
    }

    enable_color(color);

    Application::run(argv + i, argv + argc,
                     accelerator, stack_type, stack_index);
}

} // namespace Executable

ENYX_CORES_NAMESPACE_END
