#pragma once

#include <enyx/cores/flash/flash.hpp>
#include <enyx/hw/accelerator.hpp>
#include <enyx/hw/mmio.hpp>
#include <enyx/hw/core_tree.hpp>
#include <enyx/hw/core.hpp>

#include "common.hpp"

class runner {
    public:
        runner(std::string const & accelerator_arg);

        void run(struct run_params & params);

    private:

        void read_memory();
        void write_memory();
        void read_register();
        void write_register();


        enyx::flash::flash::section
        get_flash_section();

        enyx::hw::accelerator accelerator_;
        enyx::hw::mmio mmio_;
        enyx::hw::core_tree core_tree_;
        enyx::hw::core root_;
        enyx::flash::flash flash_;
        struct run_params params_;
};
