#pragma once

#include <enyx/cores_c/data_stream/sink.h>
#include <enyx/cores_c/symbol_visibility.h>

/**
 * EMI control object.
 *
 * This object can be used to update TCP stack/sessions parameters by sending
 * EMI commands through a dedicated command channel.
 * It can be used to make low latency ajustments to a running TCP stack/session.
 */
typedef struct enyx_tcp_emi_control enyx_tcp_emi_control;

/**
 * Create an EMI control object.
 *
 * @param hw_sink The hardware sink connected to the stack input EMI channel
 * @return An EMI control object on success, @b NULL on error (with @b errno set
 *         accordingly)
 */
ENYX_CORES_C_SYMBOL_VISIBILITY enyx_tcp_emi_control *
enyx_tcp_emi_control_create(enyx_data_stream_sink * hw_sink);

/**
 * Destroy an EMI control object
 *
 * @param emi_control The EMI control object to destroy
 */
ENYX_CORES_C_SYMBOL_VISIBILITY void
enyx_tcp_emi_control_destroy(enyx_tcp_emi_control * emi_control);

/**
 * Set the TCP session @p session_id window size.
 *
 * @param emi_control The EMI control object to use
 * @param session_id The ID of the TCP session to update
 * @param window_size The TCP window size to set
 * @return 0 on success, -1 on error (with @b errno set accordingly)
 */
ENYX_CORES_C_SYMBOL_VISIBILITY int
enyx_tcp_emi_control_set_window_size(enyx_tcp_emi_control * emi_control,
                                     uint32_t session_id,
                                     size_t window_size);
