/**
 * @file
 *
 * This file contains the preprocessor definition used to control
 * the function symbol visibility.
 */

#pragma once

#ifdef __cplusplus
#   define ENYX_CORES_C_SYMBOL_VISIBILITY extern "C" __attribute__((visibility("default")))
#else
#   define ENYX_CORES_C_SYMBOL_VISIBILITY extern __attribute__((visibility("default")))
#endif

#ifdef ENYX_CORES_DISABLE_DEPRECATED_WARNING
#   define ENYX_CORES_C_DEPRECATED(msg)
#else
#   define ENYX_CORES_C_DEPRECATED(msg) __attribute__((deprecated(msg)))
#endif

/**
 * @def ENYX_CORES_C_SYMBOL_VISIBILITY
 *
 * Set the shared library symbol visibility.
 *
 * @since 6.0.0
 */
