/// @file enyx_hw_sink.h
#pragma once

#include <enyx/hw_c/c2a_stream.h>

#include <enyx/cores_c/symbol_visibility.h>
#include <enyx/cores_c/data_stream/sink.h>

/**
 *  Create an data_stream sink from an enyx hw @p stream library
 *
 *  This type of sink is a bottom sink as it doesn't send
 *  data to an underlying sink but to an
 *  enyx::hw c2a @p stream.
 *
 *  The user may send data directly from this source or
 *  link it with another sink for example
 *  to insert some header to the data to send.
 *
 *  Usage:
 *  @code
 *  enyx_data_stream_sink sink;
 *  if (enyx_data_stream_sink_from_enyx_hw_stream(&sink, c2a_stream) < 0)
 *  {
 *      perror("enyx_data_stream_sink_from_enyx_hw_stream");
 *      return -1;
 *  }
 *
 *  char buffer[] = "payload";
 *  int failure;
 *  do
 *      failure = enyx_data_stream_sink_send(&sink,
 *                                           buffer, sizeof(buffer),
 *                                           NULL);
 *  while (failure < 0 && errno == EAGAIN);
 *
 *  if (failure)
 *  {
 *      perror("enyx_data_stream_sink_send");
 *      return -1;
 *  }
 *  @endcode
 *  @param sink The sink to fill
 *  @param stream The c2a stream to use
 *  @return 0 on success, -1 on error (@b errno is set accordingly)
 */
ENYX_CORES_C_SYMBOL_VISIBILITY int
enyx_data_stream_sink_from_enyx_hw_stream(enyx_data_stream_sink * sink,
                                          enyx_hw_c2a_stream * stream);
