ENYX_CORES_NAMESPACE_BEGIN

namespace test_point {

inline
test_point::test_point(hw::core const & core)
    : test_point_core_(core)
    , test_point_c_(::enyx_test_point_create(test_point_core_.handle()))
{
    if (! test_point_c_)
        throw std::system_error{errno, std::generic_category(),
                                "Failed to create test_point object"};
}

inline result<uint32_t>
test_point::get_packet_count() const noexcept
{
    uint32_t count;
    if (enyx_test_point_get_packet_count(handle(), &count) < 0)
        return std::error_code{errno, std::generic_category()};

    return count;
}

inline result<uint32_t>
test_point::get_bytes_count() const noexcept
{
    uint32_t count;
    if (enyx_test_point_get_bytes_count(handle(), &count) < 0)
        return std::error_code{errno, std::generic_category()};

    return count;
}

inline result<uint32_t>
test_point::get_error_count() const noexcept
{
    uint32_t count;
    if (enyx_test_point_get_error_count(handle(), &count) < 0)
        return std::error_code{errno, std::generic_category()};

    return count;
}

inline result<uint32_t>
test_point::get_drop_count() const noexcept
{
    uint32_t count;
    if (enyx_test_point_get_drop_count(handle(), &count) < 0)
        return std::error_code{errno, std::generic_category()};

    return count;
}

inline result<bool>
test_point::is_drop_mode_enabled() const noexcept
{
    auto ret = enyx_test_point_is_drop_mode_enabled(handle());
    if (ret < 0)
        return std::error_code{errno, std::generic_category()};

    return ret;
}

inline result<void>
test_point::enable_drop_mode() const noexcept
{
    auto ret = enyx_test_point_enable_drop_mode(handle());
    if (ret < 0)
        return std::error_code{errno, std::generic_category()};

    return {};
}

inline result<void>
test_point::disable_drop_mode() const noexcept
{
    auto ret = enyx_test_point_disable_drop_mode(handle());
    if (ret < 0)
        return std::error_code{errno, std::generic_category()};

    return {};
}

inline result<bool>
test_point::get_link_status() const noexcept
{
    auto ret = enyx_test_point_get_link_status(handle());
    if (ret < 0)
        return std::error_code{errno, std::generic_category()};

    return ret;
}

inline result<uint32_t>
test_point::get_link_loss_count() const noexcept
{
    uint32_t count;
    if (enyx_test_point_get_link_loss_count(handle(), &count) < 0)
        return std::error_code{errno, std::generic_category()};

    return count;
}

inline result<bool>
test_point::is_ready_to_drop() const noexcept
{
    auto ret = enyx_test_point_is_ready_to_drop(handle());
    if (ret < 0)
        return std::error_code{errno, std::generic_category()};

    return ret;
}

inline result<bool>
test_point::is_ready_to_backpressure() const noexcept
{
    auto ret = enyx_test_point_is_ready_to_backpressure(handle());
    if (ret < 0)
        return std::error_code{errno, std::generic_category()};

    return ret;
}

inline result<bool>
test_point::is_ready_to_generate_errors() const noexcept
{
    auto ret = enyx_test_point_is_ready_to_generate_errors(handle());
    if (ret < 0)
        return std::error_code{errno, std::generic_category()};

    return ret;
}

inline result<void>
test_point::generate_drops(uint16_t count) noexcept
{
    if (enyx_test_point_generate_drops(handle(), count) < 0)
        return std::error_code{errno, std::generic_category()};

    return {};
}

inline result<void>
test_point::generate_backpressure(uint16_t ticks) noexcept
{
    if (enyx_test_point_generate_backpressure(handle(), ticks) < 0)
        return std::error_code{errno, std::generic_category()};

    return {};
}

inline result<void>
test_point::generate_errors(uint16_t count) noexcept
{
    if (enyx_test_point_generate_errors(handle(), count) < 0)
        return std::error_code{errno, std::generic_category()};

    return {};
}

inline ::enyx_test_point const *
test_point::handle() const noexcept
{
    return test_point_c_.get();
}

inline ::enyx_test_point *
test_point::handle() noexcept
{
    return test_point_c_.get();
}

} /* namespace test_point */

ENYX_CORES_NAMESPACE_END
