ENYX_CORES_NAMESPACE_BEGIN

namespace probes {

inline
system::system(hw::core const & root)
    : root_(root)
    , system_(::enyx_probes_system_create(root_.handle()))
{
    if (! system_)
        throw std::system_error{errno, std::generic_category(),
                                "Failed to construct system"};
}

inline ::enyx_probes_system *
system::handle() noexcept
{
    return system_.get();
}

inline ::enyx_probes_system const *
system::handle() const noexcept
{
    return system_.get();
}

inline result<system::collectors>
system::enumerate_collectors() const noexcept
{
    auto const collectors_count
        = ::enyx_probes_system_enumerate_collectors(handle(),
                                                    nullptr, 0);
    if (collectors_count < 0)
        return {std::error_code{errno, std::generic_category()}};

    std::vector<::enyx_probes_collector *> handles(collectors_count);
    if (::enyx_probes_system_enumerate_collectors(handle(),
                                                  handles.data(),
                                                  handles.size()) < 0)
        return {std::error_code{errno, std::generic_category()}};

    collectors result;
    for (auto collector_handle : handles)
        result.emplace_back(root_, collector_handle);

    return {std::move(result)};
}

inline result<system::probes>
system::enumerate_probes(collector const & collector)
{
    auto const probes_count
        = ::enyx_probes_system_enumerate_probes(handle(), collector.handle(),
                                                nullptr, 0);
    if (probes_count < 0)
        return {std::error_code{errno, std::generic_category()}};

    std::vector<::enyx_probes_probe *> handles(probes_count);
    if (::enyx_probes_system_enumerate_probes(handle(), collector.handle(),
                                              handles.data(),
                                              handles.size()) < 0)
        return {std::error_code{errno, std::generic_category()}};

    probes result;
    for (auto handle : handles)
        result.emplace_back(root_, handle);

    return {std::move(result)};
}

inline result<mtg>
system::get_mtg() const noexcept
{
    auto const mtg_handle = ::enyx_probes_system_get_mtg(handle());
    if (! mtg_handle)
        return {std::error_code{errno, std::generic_category()}};

    return mtg_handle;
}

inline std::ostream &
operator<<(std::ostream & out, system const & p)
{
    out << "system";
    return out;
}

} /* namespace probes */

ENYX_CORES_NAMESPACE_END
